import React from "react";
import "./product.css";

export default class Product extends React.Component {
    constructor(props) {
        super(props);
        this.state = {};
        this.handleClick = this.handleClick.bind(this);
    }

    handleClick(item){
        this.props.onClick(item);
    }

    render() {
        const {item} = this.props;
        
        return (
            <div className="col-6 col-md-4 col-lg-3">
                <div className="row-wrapper" onClick={() => this.handleClick(item)}>
                    <div className="box device">
                        <div className="product-icon-wrrapper">
                            <img src={item.icon}/>
                        </div>
                        <div className="product-groups-row">
                            {item.title}
                        </div>
                    </div>
                </div>
            </div>           
        );
    }
}
