import React from "react";
import "./order.css";

export default class Order extends React.Component {
    
    constructor(props) {
        super(props);
        
    }


    completeCountDownHandle(){

    }


    render() {
        const {item} = this.props;
        
        return (
            <div className="col-12">
                <div className="row-wrapper box device">
                    <div className="device-item-container">
                        <div className="header">
                            <div className="">
                                <img
                                    src={item.image}
                                    alt="پنل کاربری"
                                    width="40px"
                                    className="icon-image avatar"
                                />
                            </div>
                            <div className="device-content">
                                <h3>{item.technicianName}</h3>
                                <p>{item.technicianCode}</p>
                            </div>
                        </div>
                        <div className="product-setting">
                            <button className="cancelBtn ">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor"  viewBox="0 0 329.26933 329">
                                    <path d="m194.800781 164.769531 128.210938-128.214843c8.34375-8.339844 8.34375-21.824219 0-30.164063-8.339844-8.339844-21.824219-8.339844-30.164063 0l-128.214844 128.214844-128.210937-128.214844c-8.34375-8.339844-21.824219-8.339844-30.164063 0-8.34375 8.339844-8.34375 21.824219 0 30.164063l128.210938 128.214843-128.210938 128.214844c-8.34375 8.339844-8.34375 21.824219 0 30.164063 4.15625 4.160156 9.621094 6.25 15.082032 6.25 5.460937 0 10.921875-2.089844 15.082031-6.25l128.210937-128.214844 128.214844 128.214844c4.160156 4.160156 9.621094 6.25 15.082032 6.25 5.460937 0 10.921874-2.089844 15.082031-6.25 8.34375-8.339844 8.34375-21.824219 0-30.164063zm0 0"/>
                                </svg>
                                <span> لغو درخواست</span> 
                            </button>
                        </div>
                    </div>
                    <div className="d-flex flex-column">
                        <div className="warranty-row justify-content-between">
                            <button className="button tellBtn">
                                <i>
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor"  viewBox="0 0 1000 1000">
                                    <g xmlns="http://www.w3.org/2000/svg" transform="translate(0.000000,511.000000) scale(0.100000,-0.100000)"><path d="M1916.4,4915.3c-904.5-385.6-1570.6-937.2-1766.9-1456.1c-44.4-116.9-51.4-182.3-49.1-462.8c2.3-607.7,149.6-1280.8,446.4-2033.4C951.1-60.6,1547.1-983.8,2409.6-1923.4c1537.9-1673.4,3604-2776.6,5377.9-2865.4c331.9-18.7,486.1,11.7,745.6,147.2c432.4,224.4,965.3,937.2,1285.5,1717.9c93.5,224.4,100.5,271.1,51.4,364.6C9830.2-2481.9,7673-948.7,7539.8-902c-95.8,30.4-203.3,21-306.2-30.4c-35.1-18.7-226.7-233.7-427.7-476.8c-409-497.8-465.1-542.2-691.8-544.6c-123.9,0-158.9,11.7-446.4,170.6C4372.8-1075,3809.6-511.7,3101.4,783.1c-158.9,289.8-170.6,322.6-170.6,448.8c2.3,224.4,53.8,289.8,544.6,691.8c238.4,194,451.1,388,476.8,427.7c49.1,86.5,56.1,271.1,14,355.3c-16.4,30.4-378.6,549.2-804,1149.9c-497.8,708.2-794.7,1107.8-836.7,1128.9C2229.6,5034.5,2175.8,5025.2,1916.4,4915.3z"/></g>
                                </svg>
                                </i>
                            </button>
                            <h3 className="notice">ارائه کارت ملی به تکنسین الزامی می باشد.</h3>
                        </div>

                        <div className="row device-detail font-s">
                            <div className="col-12 mb-03">
                                <span className="bold font-m"> {item.productName}</span>
                            </div>
                            <div className="col-12 mb-03">
                                <span className="letterTitle">نوع درخواست:</span>
                                {item.type}
                            </div>
                            <div className="col-6 mb-03">
                                <span className="letterTitle">سریال:</span>
                                {item.productSerial}
                            </div>
                            <div className="col-6 mb-03">
                                <span className="letterTitle">مدل:</span>
                                {item.productModel}
                            </div>
                            <div className="col-6 mb-03">
                                <span className="letterTitle">کد پیگیری:</span>
                                {item.receipt}
                            </div>
                            <div className="col-6 mb-03">
                                <span className="letterTitle">تاریخ ثبت:</span>
                                {item.date}
                            </div>
                            
                        </div>

                        <div className="order-status-bar">
                            <div className="order-status-bar__status">
                                <div className="order-status-bar__current-status" style={{"color" : "#2e7b32"}}>
                                    {item.progressTitle}
                                </div>
                            </div>
                            <div className="order-status-bar__progress">
                                <div className="order-status-bar__progress-bar" style={{"backgroundColor": "#4caf50", "width": item.progressPercent + "%"}}></div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>            
        );
    }
}
