import React from "react";
import Device from "./Device";

export default class Devices extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            loading: true
        };
    }

    render() {
        const items = this.props.items;
        
        return (
            <>
                {items && Object.keys(items).length > 0 && (
                    <div className="wrapper">
                        <div className="row no-gutters">
                            {items.map((item, index) => (
                                <Device item={item} key={index}/>
                            ))}
                        </div>
                    </div>
                )}
            </>
        );
    }
}
