import React from "react";
import "./device.css";
import CountDown from "./CountDown";
import persianDate from 'persian-date/dist/persian-date.min.js';

export default class Device extends React.Component {
    constructor(props) {
        super(props);
        const warrantyEndDate = new persianDate(this.props.item.warrantyEndDate.split("-").map(str => parseInt(str,10))).toDate().getTime();
        const priodicEndDate = new persianDate(this.props.item.priodicEndDate.split("-").map(str => parseInt(str,10))).toDate().getTime();
        this.state = {
            warrantyEndDate,
            priodicEndDate
        };
        this.threshold = 24 * 60 * 60 * 1000 * 20;
    }


    completeCountDownHandle(){

    }


    render() {
        const {item} = this.props;
        const now = new Date().getTime();
        var warrantyDiff = this.state.warrantyEndDate - now;
        var priodicDiff = this.state.priodicEndDate - now;

        return (
            <div className="col-12">
                <div className="row-wrapper box device">
                    <div className="device-item-container">
                        <div className="header">
                            <div className="product-img-container">
                                <img
                                    src={item.image_url}
                                    alt="پنل کاربری"
                                    width="40px"
                                    className="icon-image profileImg"
                                />
                            </div>
                            <div className="device-content">
                                <h3>{item.productName}</h3>
                                <p>{item.model}</p>
                            </div>
                        </div>
                        <div className="product-setting">
                            <button className="settingBtn circleBtn">
                                <i>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"  viewBox="0 0 16 16">
                                        <path d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z"/>
                                </svg>
                                </i>
                            </button>
                        </div>
                    </div>
                    <div className="d-flex flex-column">
                            {warrantyDiff < 0 ? (
                                <div className="warranty-row justify-content-between">
                                    <h3 className="label">تاریخ اتمام گارانتی: </h3>
                                    <div className="countDown">
                                        <div className="block danger label">
                                            {new persianDate(this.state.warrantyEndDate).format("DD MMMM YYYY")}
                                        </div>
                                    </div>
                                    <button className="button success-box requestSubmit">قبل از خرابی تمدید کنید!</button>
                                </div>
                            ) : (warrantyDiff > this.threshold ? (
                                <div className="warranty-row">
                                    <h3 className="label">تاریخ اتمام گارانتی: </h3>
                                    <div className="countDown">
                                        <div className="block success label">
                                            {new persianDate(this.state.warrantyEndDate).format("DD MMMM YYYY")}
                                        </div>
                                    </div>
                                </div>
                            ) : (
                                <div className="warranty-row justify-content-between">
                                    <h3 className="label">تاریخ اتمام گارانتی: </h3>
                                    <CountDown onComplete={this.completeCountDownHandle} restart={!this.state.timerCompleted} format="dd:hh:mm:ss" deadline={this.state.warrantyEndDate}/>
                                    <button className="button success-box requestSubmit">قبل از خرابی تمدید کنید!</button>
                                </div>
                            ))}
                            
                       
                        
                            {priodicDiff < 0 ? (
                               <div className="warranty-row justify-content-between">
                                    <h3 className="label"> سرویس دوره ای: </h3>
                                    <div className="countDown">
                                        <div className="block danger label">
                                            {new persianDate(this.state.priodicEndDate).format("DD MMMM YYYY")}
                                        </div>
                                    </div>
                                    <button className="button success-box requestSubmit">قبل از خرابی تمدید کنید!</button>
                                </div>
                            ) : (priodicDiff > this.threshold ? (
                                <div className="warranty-row ">
                                    <h3 className="label"> سرویس دوره ای: </h3>
                                    <div className="countDown">
                                        <div className="block success label">
                                            {new persianDate(this.state.priodicEndDate).format("DD MMMM YYYY")}
                                        </div>
                                    </div>
                                </div>
                            ) : (
                                <div className="warranty-row justify-content-between">
                                    <h3 className="label"> سرویس دوره ای: </h3>
                                    <CountDown onComplete={this.completeCountDownHandle} restart={!this.state.timerCompleted} format="dd:hh:mm:ss" deadline={this.state.priodicEndDate}/>
                                    <button className="button success-box requestSubmit">قبل از خرابی سرویس کنید!</button>
                                </div>
                            ))}
                       
                        <div className="actions-row">
                            <button className="button dark-box requestSubmit">درخواست تعمیر</button>
                            <button className="button dark-box requestSubmit">درخواست نصب و راه اندازی</button>
                            <button className="button dark-box requestSubmit">مشاوره فنی</button>
                        </div>
                    </div>
                </div>
            </div>           
        );
    }
}
