import React, { Component } from 'react';
import PropTypes from 'prop-types';
import persianDate from 'persian-date/dist/persian-date.min.js';
import "./countDown.css";

export default class CountDown extends React.Component {
    static propTypes = {
        onComplete: PropTypes.func,
        loading: PropTypes.bool,
        time: PropTypes.number,
        className: PropTypes.string,
      };

    constructor(props) {
      super(props);
      this.state = {
        days: 0,
        minutes: 0,
        hours: 0,
        secounds: 0,
        time_up:"TIME::MID"
    }
     
      const deadline = this.props.deadline;
      this.state = { deadline };
      this.timer = 0;
      this.threshold = this.props.threshold ?? 24 * 60 * 60 * 1000 * 20;
      this.countDown = this.countDown.bind(this);
    }
  
    componentDidMount() {
      this.startTimer();
    }

    componentWillUnmount(){
      clearInterval(this.timer);
    }

    startTimer() {
      if (this.timer == 0) {
        this.timer = setInterval(this.countDown, 1000);
      }
    }
  
    countDown() {
      var now = new Date().getTime();
      var t = this.state.deadline - now;
      var days = Math.floor(t / (1000 * 60 * 60 * 24));
      var hours = Math.floor((t % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
      var minutes = Math.floor((t % (1000 * 60 * 60)) / (1000 * 60));
      var seconds = Math.floor((t % (1000 * 60)) / 1000);
      this.setState({days, minutes, hours, seconds})
     
      if (t < 0) {
          clearInterval(this.timer);
          this.setState({ days: 0, minutes: 0, hours: 0, seconds: 0, time_up: "TIME::LOW" })
          this.props.onComplete();
          
      }

      if (t > this.threshold) {
        clearInterval(this.timer);
        this.setState({ days: 0, minutes: 0, hours: 0, seconds: 0, time_up: "TIME::HIGH" })
        this.props.onComplete();
    }

    }
  
    render() {
      if(this.props.restart && this.timer != 0){
        this.startTimer();
      }
      const { days, seconds, hours, minutes, time_up } = this.state
     
      return(
        <>
        {this.props.format == 'ss' && (
          <span>
            {this.state.time}
          </span>
        )}
        {this.props.format == 'dd:hh:mm:ss' && (
            <div className="countDown">
              <div className="block">
                  <div className="countDownBox"><span className="seconds" id="second">{seconds}</span></div>
                  <div className="smalltext">ثانیه</div>
              </div>
              <div className="block">
                  <div className="countDownBox"><span className="minutes " id="minute">{minutes}</span></div>
                  <div className="smalltext">دقیقه</div>
              </div>
              <div className="block">
                  <div className="countDownBox"><span className="hours " id="hour">{hours}</span></div>
                  <div className="smalltext">ساعت</div>
              </div>
              <div className="block">
                  <div className="countDownBox"><span className="days " id="day">{days}</span></div>
                  <div className="smalltext">روز</div>
              </div>
            </div>
        )}
      </>        
      );
    }
  }