import React from "react";
import EmblaCarousel from "./EmblaCarousel";

export default class Carousel extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            loading: true
        };
    }

    componentDidMount() {
    }
    
    componentDidUpdate(){
       
        if(this.props.slides && Object.keys(this.props.slides).length){
            this.setState({loading: false});
        }
    }

    render() {
        
        return (
            <>
                {Object.keys(this.props.slides).length < 1 ? (
                    <div>loading...</div>
                ) : 
                ( 
                    <EmblaCarousel slides={this.props.slides} />
                )}
               
            </>
        );
    }
}
