import React from "react";
import "./brand.css";
import { AppContext } from "../../../appContext";

export default class Brand extends React.Component {
    static contextType = AppContext;
    constructor(props) {
        super(props);
        this.state = {};
    }

    componentDidMount(){
        if(this.context)
            this.state.appStatus = this.context.appStatus;
    }

    handleClick(brand,group){
        this.state.appStatus({key: 'brand', value: brand.id});
        this.state.appStatus({key: 'group', value: group.id});
        this.props.history.push('/products');
    }


    render() {
        const {item} = this.props;
        const items = Object.values(item.items)
        return (
            <div className="col-12">
                <div className="row-wrapper box device">
                    <div className="brand-icon-wrrapper">
                        <img src={item.icon}/>
                    </div>
                    <div className="brand-groups-row">
                        {items.map((gr, index) => (
                            <button key={index} className="button dash-button display" onClick={()=>this.handleClick(item,gr)}>
                                <img src={gr.icon} className="brandGBIMG"/>
                                <span>{gr.title}</span>
                            </button>
                        ))}
                    </div>
                </div>
            </div>           
        );
    }
}
