import React, { useContext } from 'react';
import { Route, Switch, Redirect } from 'react-router-dom';
import { withRouter } from 'react-router'
import { AppContext } from './appContext';

const Navigator = props => {
    const { routes, authenticated } = useContext(
        AppContext,
    );

    return (
        <Switch>
            {routes.map((route, i) => {
                const View = route.component;
                
                return (
                    <Route
                        key={i}
                        path={route.path}
                        exact
                        render={routeProps => {
                            if (route.auth && !authenticated) {
                                    return (
                                        <Redirect to="/signin"/>
                                    );
                            }
                            if(route.path == '/signin' && authenticated){
                                return (
                                    <Redirect to="/"/>
                                );
                            }
                            
                            return <View {...routeProps} />;
                        }}
                    />
                );
            })}
        </Switch>
    );
};

export const NavigatorWR = withRouter(Navigator);


