import React, { useState, useEffect } from 'react';
import { HashRouter as Router } from 'react-router-dom'; 
import { NavigatorWR as Navigator } from './Navigator';
import { ROUTES } from './routes';
import { Loading } from './components/core/Loading';
import { AppProvider } from './appContext';
import { BrowserHistory } from './BrowserHistory';
import { reposition } from 'toastify-js';
import * as Const from './utils/Const';

export class App extends React.Component {
    
    constructor(props) {
        super(props);
        this.state = {
            authenticated: false,
            loading: true,
            initialized : false,
            errors: null,
            message: {},
            user: {},
            content: {},
            mobile: null,
            status: {
                prevPage : null,
                currentPage : Const.pages.HOME,
                brand: null,
                group: null,
                product: null,
                service: null,
                address: {},
                time: null,
                repair: {}
            },
        };
    }

    componentDidMount(){
        this.fetchUser();
        this.getContent();
    }

    componentDidUpdate(){
       
    }

    appStatus = newStatus => {
        
        this.setState(prevState => ({
            status: {
                ...prevState.status,
                [`${newStatus.key}`] : newStatus.value     
            }
        }))
        
    }

    /**
     * Authenticate the user.
     * @return {undefined}
     */
    authenticate = async user => {
       
        if (user === {}) {
            return;
        }
        this.setState({
            authenticated : true,
            user: user,
            loading:false
        });
    };

    getContent = async () => {
        this.setState({loading: true});
        try{
            const response = await axios.post('/request/content');
            if (Object.keys(response.data).length > 0) {
                this.setState({
                    content: response.data,
                    loading: false
                });
            }
            else{
                this.setState({loading: false});
            }
        }catch(error){
            this.setState({loading: false});
        }
    }

    /**
     * Sign out user.
     *
     * @return {undefined}
     */
    signOut = async () => {
        this.setState({loading: true});

        try {
            await axios.post('/user/signout');
            this.setState({
                loading: false,
                authenticated: false,
                mobile: null
            });
            
        } catch (error) {
            this.setState({loading: false});
        }
    };

    /**
     * Fetch the authenticated user.
     *
     * @return {any}
     */
    fetchUser = async () => {
        
        this.setState({loading: true});
        
        try {
            const response = await axios.post('/user/fetchUser');
            if (Object.keys(response.data.user).length > 0) {
                this.authenticate(response.data.user);
               
            } else {
                this.setState({loading: false});
            }
        } catch (error) {
            this.setState({loading: false});
        }
    };

    render() {
        console.log(this.state);
        const pageProps = {
            // Props
            routes: ROUTES,

            // State
            loading: this.state.loading,
            authenticated: this.state.authenticated,
            user: this.state.user,
            mobile: this.state.mobile,
            content: this.state.content,
            status: this.state.status,

            // Methods
            authenticate: this.authenticate,
            appStatus: this.appStatus

        };
        return (
            <AppProvider {...pageProps}>
                {this.state.loading ? (
                    <Loading />
                ) : (
                    <Router >
                        <Navigator />
                    </Router>
                )}
            </AppProvider>
        );
    }
}

export default App;
