import Toastify from 'toastify-js'
import $ from 'jquery'

export class DuplicateItem {
    constructor(item, duplicateBtn, removeBtn ,setting) {
        this.duplicateBtn = duplicateBtn
        this.removeBtn = removeBtn
        this.item = item
        this.rowCounter = 0
        this.setting = {'parentRow':false, 'childRow':false};
    }

    
    binding() {

        $(document).on("click",this.duplicateBtn ,(event) => {
            event.preventDefault();
            // let id = $(event.currentTarget).data("id")
            this.duplicateItem()           
        })

        $(document).on("click",this.removeBtn ,(event) => {
            event.preventDefault();
            // let id = $(event.currentTarget).data("id")
            this.removeItem(event.currentTarget)           
        })

    }

    duplicateItem(){
        if(!$(this.item).length || this.isLimited()){
            alert('امکان اضافه نمودن آیتم وجود ندارد');
            return
        }
        const lastItem = $(this.item)[$(this.item).length - 1];
        let newItem = $(lastItem).clone();
        this.updateItemsAttribute();
        let cnt = this.rowCounter;
        newItem.attr('id', 'reg_' + cnt);
        var setting = {};
        newItem.find('select, input, textarea, img, div, a, button').each(function (index, el) {
                if ($(this).attr('name') && setting.parentRow) {
                    $(this).attr('name', $(this).attr('name').toString().replace(/(\[|\()row\d+(\]|\))/, '$1row' + cnt + '$2'));
                    $(this).attr('name', $(this).attr('name').toString().replace(/(\[|\()child\d+(\]|\))/, '$1child1$2'));
                } else if ($(this).attr('name') && setting.childRow) {
                    $(this).attr('name', $(this).attr('name').toString().replace(/(\[|\()child\d+(\]|\))/, '$1child' + cnt + '$2'));
                } else if ($(this).attr('name')) {
                    $(this).attr('name', $(this).attr('name').toString().replace(/(\[|\()row\d+(\]|\))/, '$1row' + cnt + '$2'));
                }
                var id = $(this).attr('id');
                if ($('#' + id).length) {
                    $(this).attr('id', $('#' + $(this).attr('name')).length ? ($(this).attr('name') + Math.round(Math.random() * 1000000)) : $(this).attr('name'));
                } else if (id) {
                    $(this).attr('id', id);
                }
                if ($(this).hasClass('auto-increment')) {
                    if ($(this).data('zebra')) {
                        var zebra = $(this).data('zebra').split(/;/);
                        if ($(this).parent().length && zebra.length > 1) {
                            $(this).parent().css('backgroundColor', ($(this).parent().css('backgroundColor') == zebra[0].trim() ? zebra[1].trim() : zebra[0].trim()));
                        }  
                    }
                    $(this).html(App.convertDigit(((isNaN(parseInt(App.convertDigit($(this).text().trim()))) ? 0 : parseInt(App.convertDigit($(this).text().trim()))) + 1), 'fa'));
                }
                if ($(this).hasClass('remove')) $(this).remove();
                if ($(this).hasClass('tooltips')) {
                    $(this).attr('data-title', '');
                    $(this).removeAttr('data-original-title');
                }
                switch ($(this).prop('tagName').toLowerCase()) {
                    case 'select' :
                        $(this).selectedIndex = 0;
                        if ($(this).data('advancedselect') != undefined) {
                            $(this).parent().find('.select2-container').remove();
                             App.setSelect2($(this));
                        }

                        if ($(this).hasClass('reset')) {
                            if ($(this).data('advancedselect') != undefined) {
                                $(this).parent().find('.select2-container').remove();
                            }
                            $(this).find('option').eq(0).attr('selected', 'selected');
                            App.setSelect2($(this));
                        }
                        break;
                    case 'textarea':
                        $(this).val('');
                        $(this).text = null;
                        break;
                    case 'img':
                        if ($(this).hasClass('img_box') || $(this).hasClass('reset')) $(this).attr('src', null);
                        if ($(this).hasClass('delImg')) $(this).parent().remove();
                        break;                        
                    case 'div':
                        if ($(this).data('resetvalue')) $(this).html($(this).data('resetvalue'));
                        $(this).removeClass('has-success').removeClass('has-error');
                        break;
                    case 'a':
                        if ($(this).hasClass('reset')) $(this).attr('href', 'javascript:void(0);');
                        break;
                    case 'input':
                        var resetVal = $(this).data('resetvalue') ? $(this).data('resetvalue') : '';
                        if ($(this).hasClass('reset')) $(this).val(resetVal);
                        if (!$(this).hasClass('no-reset')) {
                            if ($(this).prop('type') == 'text' && !$(this).hasClass('display-rank')) $(this).val(resetVal);
                            if ($(this).prop('type') == 'number' && !$(this).hasClass('display-rank')) $(this).val(resetVal);
                            if ($(this).prop('type') == 'email') $(this).val(resetVal);
                            if ($(this).prop('type') == 'tel') $(this).val(resetVal);
                            if ($(this).prop('type') == 'date') $(this).val(resetVal);
                            if ($(this).prop('type') == 'datetime') $(this).val(resetVal);
                            if ($(this).prop('type') == 'file') $(this).val(resetVal);
                            if ($(this).prop('type') == 'checkbox') {
                                $(this).checked = false;
                                $(this).parent().removeClass('active');
                            }
                            if ($(this).prop('type') == 'radio') {
                                $(this).checked = false;
                                $(this).parent().removeClass('active');
                            }
                            if ($(this).prop('type') == 'hidden' && $(this).hasClass('reset')) $(this).val(resetVal);
                            if ($(this).prop('type') == 'radio' && $(this).parent().length)
                                $(this).parent().html($(this).parent().html().replace(/(\[|\()row\d+(\]|\))/, '$1row' + cnt + '$2'));
                                $(this).parent().removeClass('active');
                        }
                        if ($(this).hasClass('display-rank')) {
                            var newRank = parseInt($(this).val()) - 10;
                            $(this).val(newRank > 0 ? newRank : 0);
                        }
                        break;
                }
            });
            $(this.duplicateBtn).removeClass(this.duplicateBtn.split('.').join(" ")).addClass(this.removeBtn.split('.').join(" ")).find('i').removeClass('icon-plus').addClass('icon-mines');
            newItem.insertAfter((this.setting.insertAfterObject ? (this.setting.insertAfterObject.length ? this.setting.insertAfterObject : lastItem) : lastItem));
            
        
    }

    removeItem(obj) {
        var obj = $(obj);
        if (!obj.length) return false;
        obj.closest(this.item).remove();
        
    }

    updateItemsAttribute(){
        let cnt = 1;            
        $(this.item).each(function (index, el) {
            el.lang = cnt;
            $(this).find('select, input, textarea').each(function (key, val) {
                var strName = $(this).attr('name');
                if (!strName) return;
                if (this.setting && this.setting.childRow != undefined) {
                    strName = strName.replace(/(\[|\()child\d+(\]|\))/, '$1child' + cnt + '$2');
                } else {
                    strName = strName.replace(/(\[|\()row\d+(\]|\))/, '$1row' + cnt + '$2');
                }
                $(this).attr('name', strName);
                var id = $(this).attr('id');
                if ($('#' + id).length) {
                    $(this).attr('id', $('#' + $(this).attr('name')).length ? ($(this).attr('name') + Math.round(Math.random() * 1000000)) : $(this).attr('name'));
                } else if (id) {
                    $(this).attr('id', id);
                }
                if ($(this).data('advancedselect') != undefined) {
                    App.setSelect2($(this));
                }
            });
            $(this).attr('id', 'reg_' + cnt);
            cnt++;
        });
        this.rowCounter = cnt;
    }

    isLimited(){
        return false;
    }

    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 3000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
          backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)",
        }).showToast();
    }

    sendAjax(data,url){
        const res = $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    dataType: "html",
                    data: data
                });
        return res;
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }
}
