import $ from 'jquery'
import { Map } from './map'
import survey, { Survey } from './survey'
import { setSubGroup } from '../../../home/assets/js/setsubgroup'
import {selectize} from 'selectize'
import {DuplicateItem} from './duplicateItem'
import Toastify from 'toastify-js'

/**
 * The shopping cart has access to the products repository
 */
var requestBrandid = 0;
var requestGroupid = 0;
var requestProductid = 0;
var requestServiceid = 0;
$(document).ready(function () {
	var map = new Map();
	map.binding();

	var survey = new Survey();
	survey.binding();

	let duplicateItem  = new DuplicateItem('.new-request-row','.new-request-plus','.new-request-mines',{})
	duplicateItem.binding();

	$(document).on('click','.js-submit-followRequest', function(event){
		event.preventDefault();
		handleFollowRequest();
	});

	$(document).on('change', '.request-modal-form select.productList', function () {
		handleHowFindModel();
	});

	$(document).on('click','.js-submit-manual', function(event){
		event.preventDefault();
		handleManualRequest();
	});

	$(document).on('click','.js-submit-driver', function(event){
		event.preventDefault();
		handleDriverRequest();
	});


	$(document).on('click','.js-submit-check-warranty', function(event){
		event.preventDefault();
		handleCheckWarrantyRequest();
	});

	$(document).on('click','.js-submit-insert-request', function(event){
		event.preventDefault();
		$('#confirmModal').modal('show');
		
	});
	$(document).on('click','.js-modal-insert-request', function(event){
		event.preventDefault();
		handleRequestSubmit();
	});
	$(document).on('click','.js-modal-add-device', function(event){
		$('.new-requests').removeClass('d-none');
		event.preventDefault();
	});
	handleManualEvents();
	handleChangeProvince();
});

function handleManualEvents(){
	
	$(document).on('change', 'select.brandList', function () {
		let select2 = $(this).closest('.select-chain-row').find('select.groupList');
		setSubGroup(groupList, 0, $(this), select2,null,0,'انتخاب گروه محصول');
		// select2.trigger("change");
	});

	$(document).on('change', 'select.groupList', function () {
		let select2 = $(this).closest('.select-chain-row').find(' select.productList');
		setSubGroup(productList, 0, $(this), select2,null,0,'انتخاب محصول');
		// select2.trigger("change");
	});

	$(document).on('change', 'select.productList', function () {
		if ($(this).closest('.select-chain-row').find('select.modelList').length)
			handleModelListSelect();
	});
}

function handleChangeProvince(){
	$(document).on('change', '#provinceListCombo', function () {
		setSubGroup(cityList, 0, $('#provinceListCombo'), $('#cityListCombo'), null,$('#cityListCombo').val() || 0,'شهر');
		//$('#regionListCombo').html('<option value="0" disabled selected> منطقه </li>');
		//$('#parishListCombo').html('<option value="0" disabled selected> محله </li>');
	});

	$(document).on('change', '#cityListCombo', function () {
		setSubGroup(regionList, 0, $('#cityListCombo'), $('#regionListCombo'), null, $('#regionListCombo').val() || 0,'منطقه');
		//handleCityListSelect();
		//$('#parishListCombo').html('<option value="0" disabled selected> محله </li>');
	});

	$(document).on('change', '#regionListCombo', function () {
		setSubGroup(parishList, 0, $('#regionListCombo'), $('#parishListCombo'), null,$('#parishListCombo').val() || 0,'محله');
		//handleRegionListSelect();
	});
	
	if(parseInt($('#provinceListCombo').val())) $('#provinceListCombo').trigger('change');
	if(parseInt($('#cityListCombo').val())) $('#cityListCombo').trigger('change');
	if(parseInt($('#regionListCombo').val())) $('#regionListCombo').trigger('change');
}

function handleModelListSelect() {
	const id = $('.manual-form select.productList').val();

	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/getProductModels',
		data: {
			'productid': id,
		},
		beforeSend: function () {
			$('.manual-form select.modelList').prop("disabled", true);
			$('.modelListLoading').removeClass('d-none');
			if($('.manual-form select.modelList')[0].selectize){
				let y = $('.manual-form select.modelList')[0].selectize.destroy();
			}
			
		},
		success: function (data) {
			//var obj = jQuery.parseJSON(data);
			const options = data.map(function (item) {
				return '<option value="' + $.trim(item) + '">' + $.trim(item) + '</option>';
			}).join(' ');
			$('.manual-form select.modelList').html(options);
			$('.manual-form select.modelList').prop("disabled", false);
			$('.manual-form select.modelList').selectize({
				onFocus : function (){
					let $activeSelect = $('.manual-form select.modelList')[0].selectize;
					let $value = $activeSelect.getValue();
					 if ($value.length > 0) {
						   $activeSelect.clear( true);
					 }
			  }
			});

			
			$('.modelListLoading').addClass('d-none');
		}
	});
}

function handleManualRequest() {
	const id = $('.manual-form select.modelList').val();
	const captcha = $('input[name="captcha"]').val();

	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/getManual',
		data: {
			'model': id,
			'captcha' : captcha
		},
		beforeSend: function () {
			$('.js-submit-manual').append('<span class="spinner-grow" role="status" aria-hidden="true"></span>');
			$('.js-submit-manual').addClass("disabled");
		},
		error: function(xhr, ajaxOptions, thrownError){
			if (typeof xhr.responseJSON.message == 'object'){
				let errorText = '';
				$.each(xhr.responseJSON.message,function(key,value){
					errorText = errorText +  value  + '<br>';
				})
				$('#messageModal .modal-message').html(errorText);
			}else{
				$('#messageModal .modal-message').html(xhr.responseJSON.message);
			}
			$('.captcha-input img').attr('src', xhr.responseJSON.captcha);
			$('#messageModal').modal('show');

			
			$('.js-submit-manual').find('.spinner-grow').remove();
			$('.js-submit-manual').removeClass("disabled");
			// $.ajax({
			// 	type: "GET",
			// 	url: '/ajax_regen_captcha',
			// }).done(function( msg ) {
			// 	$('.captcha-input img').attr('src', msg);
			// });
				
			
		},
		success: function (data) {
			//var obj = jQuery.parseJSON(data);
			let tableRow = $('.js-table .js-table-row');
			let iteration = 0;
			$.each(data, function(key,value){
				// const aValue = '<a href="' + value + '" target="_blank">' + value + '</a>';
				const aValue = `<a href="`+ value +`" class="d-flex flex-column mr-3">
									<img src="/images/fileIcon/pdf.png" width="60px">
									<span>دانلود فایل</span>
								</a>`;
				if(iteration == 0){
					tableRow.find('.js-table-row-content').html(aValue);
				}else{
					let newObj = tableRow.find('.js-table-row-content').clone();
					newObj.html(aValue);
					tableRow.append(newObj);
				}
				iteration++;
			});
			$('.js-submit-manual').find('.spinner-grow').remove();
			$('.js-table').removeClass('d-none');
			$('.js-submit-manual').removeClass("disabled");
			$('html, body').animate({
				scrollTop: $(".js-table").offset().top - 100
			}, 1000, function() {
				
			});
		}
	});
}

function handleDriverRequest() {
	const id = $('.manual-form select.modelList').val();
	const captcha = $('input[name="captcha"]').val();

	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/getDriver',
		data: {
			'model': id,
			'captcha' : captcha
		},
		beforeSend: function () {
			$('.js-submit-driver').append('<span class="spinner-grow" role="status" aria-hidden="true"></span>');
			$('.js-submit-driver').addClass("disabled");
		},
		error: function(xhr, ajaxOptions, thrownError){
			if (typeof xhr.responseJSON.message == 'object'){
				let errorText = '';
				$.each(xhr.responseJSON.message,function(key,value){
					errorText = errorText +  value  + '<br>';
				})
				$('#messageModal .modal-message').html(errorText);
			}else{
				$('#messageModal .modal-message').html(xhr.responseJSON.message);
			}
			$('.captcha-input img').attr('src', xhr.responseJSON.captcha);
			$('#messageModal').modal('show');

			
			$('.js-submit-driver').find('.spinner-grow').remove();
			$('.js-submit-driver').removeClass("disabled");
			// $.ajax({
			// 	type: "GET",
			// 	url: '/ajax_regen_captcha',
			// }).done(function( msg ) {
			// 	$('.captcha-input img').attr('src', msg);
			// });
				
			
		},
		success: function (data) {
			var obj = jQuery.parseJSON(data);
			
			let tableRow = $('.js-table .js-table-row');
			let iteration = 0;
			$.each(obj, function(key,value){
				// const aValue = '<a href="' + value + '" target="_blank">' + value + '</a>';
				const aValue = `<a href="`+ value +`" class="d-flex flex-column mr-3">
									<img src="/images/fileIcon/doc2.png" width="60px">
									<span>`+key+`</span>
								</a>`;
				if(iteration == 0){
					tableRow.find('.js-table-row-content').html(aValue);
				}else{
					let newObj = tableRow.find('.js-table-row-content').clone();
					newObj.html(aValue);
					tableRow.append(newObj);
				}
				iteration++;
			});
			$('.js-submit-driver').find('.spinner-grow').remove();
			$('.js-table').removeClass('d-none');
			$('.js-submit-driver').removeClass("disabled");
			$('html, body').animate({
				scrollTop: $(".js-table").offset().top - 100
			}, 1000, function() {
				
			});
		}
	});
}

function handleFollowRequest() {
	const type = $('.follow-request-form select.typeList').val();
	const data = $('.follow-request-form input.dataInput').val();
	const captcha = $('input[name="captcha"]').val();

	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/getFollowRequest',
		data: {
			'type': type,
			'data': data,
			'captcha' : captcha
		},
		beforeSend: function () {
			$('.js-submit-followRequest').append('<span class="spinner-grow" role="status" aria-hidden="true"></span>');
			$('.js-submit-followRequest').addClass("disabled");
		},
		error: function(xhr, ajaxOptions, thrownError){
			if (typeof xhr.responseJSON.message == 'object'){
				let errorText = '';
				$.each(xhr.responseJSON.message,function(key,value){
					errorText = errorText +  value  + '<br>';
				})
				$('#messageModal .modal-message').html(errorText);
			}else{
				$('#messageModal .modal-message').html(xhr.responseJSON.message);
			}
			$('.captcha-input img').attr('src', xhr.responseJSON.captcha);
			$('#messageModal').modal('show');

			$('.js-submit-followRequest').find('.spinner-grow').remove();
			$('.js-submit-followRequest').removeClass("disabled");
			
		},
		success: function (data) {
			//var obj = jQuery.parseJSON(data);
			let tableRow = $('.js-table .js-table-row');
			let iteration = 0;
			
			$.each(data, function(key,value){
				
				if(iteration == 0){
					let newObj = tableRow;
					newObj.find('.js-table-row-serviceNo').html(value.ServiceNo);
					newObj.find('.js-table-row-serviceType').html(value.DescFa);
					newObj.find('.js-table-row-productName').html(value.ProductFarsiName);
					newObj.find('.js-table-row-model').html(value.Model);
					newObj.find('.js-table-row-state1').html(value.DescFa1);
					newObj.find('.js-table-row-state2').html(value.DescFa2);
					newObj.find('.js-table-row-technician').html(value.TechnicianName);

				}else{
					let newObj = tableRow.clone();
					newObj.find('.js-table-row-serviceNo').html(value.ServiceNo);
					newObj.find('.js-table-row-serviceType').html(value.DescFa);
					newObj.find('.js-table-row-productName').html(value.ProductFarsiName);
					newObj.find('.js-table-row-model').html(value.Model);
					newObj.find('.js-table-row-state1').html(value.DescFa1);
					newObj.find('.js-table-row-state2').html(value.DescFa2);
					newObj.find('.js-table-row-technician').html(value.TechnicianName);
					tableRow.append(newObj);
				}
				iteration++;
			});
			$('.js-submit-followRequest').find('.spinner-grow').remove();
			$('.js-table').removeClass('d-none');
			$('.js-submit-followRequest').removeClass("disabled");
			$('html, body').animate({
				scrollTop: $(".js-table").offset().top -100
			}, 1000, function() {
				
			});
		}
	});
}

function handleHowFindModel() {
	const id = $('.request-modal-form select.productList').val();

	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/modelLocation',
		data: {
			'productid': id,
		},
		beforeSend: function () {
			$('.request-modal-form select.productList').prop("disabled", true);
			$('.request-modal-form select.groupList').prop("disabled", true);
		},
		success: function (data) {
			//var obj = jQuery.parseJSON(data);
			
			$('.how-find-model-content').html(data);
			$('.request-modal-form select.groupList').prop("disabled", false);
			$('.request-modal-form select.productList').prop("disabled", false);
		}
	});
}

function handleCheckWarrantyRequest() {
	const model = $('.manual-form select.modelList').val();
	const serial = $('.manual-form #productSerial').val();
	const captcha = $('input[name="captcha"]').val();
	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/getWarrantyDate',
		data: {
			'model': model,
			'serialno' : serial,
			'captcha' : captcha,
		},
		beforeSend: function () {
			$('.js-submit-check-warranty').append('<span class="spinner-grow" role="status" aria-hidden="true"></span>');
			$('.js-submit-check-warranty').addClass("disabled");
		},
		error: function(xhr, ajaxOptions, thrownError){
			if (typeof xhr.responseJSON.message == 'object'){
				let errorText = '';
				$.each(xhr.responseJSON.message,function(key,value){
					errorText = errorText +  value  + '<br>';
				})
				$('#messageModal .modal-message').html(errorText);
			}else{
				$('#messageModal .modal-message').html(xhr.responseJSON.message);
			}
			$('.captcha-input img').attr('src', xhr.responseJSON.captcha);
			$('#messageModal').modal('show');

			$('.js-submit-check-warranty').find('.spinner-grow').remove();
			$('.js-submit-check-warranty').removeClass("disabled");
			
		},
		success: function (data) {
			//var obj = jQuery.parseJSON(data);
			let tableRow = $('.js-table .js-table-row');
			let iteration = 0;
			tableRow.find('.js-table-row-content').html(data);
			$('.js-submit-check-warranty').find('.spinner-grow').remove();
			$('.js-table').removeClass('d-none');
			$('.js-submit-check-warranty').removeClass("disabled");
			$('#messageModal .modal-message').html(data);
			$('#messageModal').modal('show');
			$('html, body').animate({
				scrollTop: $(".js-table").offset().top - 100
			}, 1000, function() {
				
			});
		}
	});
}

function handleCityListSelect() {
	const id = $('#cityListCombo').val();

	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/getRegionByCity',
		data: {
			'id': id,
		},
		beforeSend: function () {
			$('#cityListCombo').prop("disabled", true);
			$('.modelListLoading').removeClass('d-none');
		},
		success: function (data) {
			let options = '<option value="' + 0 + '" disabled selected>' + 'منطقه ' + '</li>';
			options +=  (data.length > 1) ?
			data.map(function (item) {
				return '<option value="' + item.id + '">' + item.name + '</li>';
			}).join(' ') : '<option value="' + data.id + '">' + data.name + '</li>';
			$('#regionListCombo').html(options);

			$('#cityListCombo').prop("disabled", false);
			$('.modelListLoading').addClass('d-none');
		}
	});
}

function handleRegionListSelect() {
	const id = $('#regionListCombo').val();

	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/getParishByRegion',
		data: {
			'id': id,
		},
		beforeSend: function () {
			$('#regionListCombo').prop("disabled", true);
			$('.modelListLoading').removeClass('d-none');
		},
		
		success: function (data) {
			
			const options =  (data.length > 1) ?
			data.map(function (item) {
				return '<option value="' + item.id + '">' + item.parishName + '</li>';
			}).join(' ') : '<option value="' + data.id + '">' + data.parishName + '</li>';
			$('#parishListCombo').html(options);

			$('#regionListCombo').prop("disabled", false);
			$('.modelListLoading').addClass('d-none');
		}
	});
}

function handleRequestSubmit() {
	// fields validation
	let isValid = true;
	const persian = /^[\u0600-\u06FF\s]+$/;
	const number = /^[0-9]+$/;

	$('.js-last-step-form').find('input[type="text"], input[type="password"], textarea, select').each(function () {
		
		if($(this).data('valid') == 'only-text'){
			if ($(this).val() == "" || $(this).val() == 0 || !persian.test($(this).val()) ) {
				isValid = false;
				$(this).parent().addClass('input-error');
			}
			else {
				$(this).parent().removeClass('input-error');
			}
		}
		if($(this).data('valid') == 'only-number' && !$(this).closest('.d-none').length){
			const length = $(this).val().length;
			const min = parseInt($(this).attr('min'));
			if ($(this).val() == "" || parseInt($(this).val()) == 0 || !number.test($(this).val()) || length < min) {
				isValid = false;
				$(this).parent().addClass('input-error');
			}
			else {
				$(this).parent().removeClass('input-error');
			}
		}
		if($(this).data('valid') == 'text'){
			if ($(this).val() == "" || $(this).val() == 0 ) {
				isValid = false;
				$(this).parent().addClass('input-error');
			}
			else {
				$(this).parent().removeClass('input-error');
			}
		}
		
	});
	
	if(!isValid){
		$('html, body').animate({
            scrollTop: $(".js-last-step-form").offset().top
        }, 1000, function() {
            
		});
		return false;
	}
		
	// fields validation

	$('#firstproductcode').val(requestProductid);
	$('#firstsvstypeid').val(requestServiceid);
	const formData = $('form.f1').serialize();

	$.ajax({
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		type: 'POST',
		url: '/Request/insertService',
		data: formData,
		dataType: 'json',
		
		success: function (data) {
			let cnt = 0;
			$.each(data.result,function(key,value){
				let obj = $('.request-response-row')[$('.request-response-row').length - 1];
				if(!cnt){
					let newObj = $(obj);
					newObj.find('.serviceName').html(value.service);
					newObj.find('.productName').html(value.product);
					newObj.find('.codeName').html(value.code);
				}else{
					let newObj = $(obj).clone();
					newObj.find('.serviceName').html(value.service);
					newObj.find('.productName').html(value.product);
					newObj.find('.codeName').html(value.code);
					$(obj).parent().append(newObj);
				}
				
				cnt++;
			})
			
			$('.js-last-step-form').addClass('d-none');
			$('.js-last-step-message').removeClass('d-none');
		},
		error: function (xhr, ajaxOptions, thrownError) {
			$('.js-last-step-message .result-bank-cart .cart-alert-icon').removeClass('success').addClass('failed');
			$('.js-last-step-message .result-bank-cart .cart-alert-icon i').removeClass('icon-check').addClass('icon-close');
			$('.js-last-step-message .request-response-parent').html(xhr.responseJSON.message);
			$('.js-last-step-message').append('<div class="col-12 text-center"><a href="/request" class="btn btn-danger my-sm-0 bg-red"> درخواست مجدد</a></div>');
			$('.js-last-step-form').addClass('d-none');
			$('.js-last-step-message').removeClass('d-none');
		}

	});
}
function scroll_to_class(element_class, removed_height) {
	var scroll_to = $(element_class).offset().top - removed_height;
	if ($(window).scrollTop() != scroll_to) {
		$('html, body').stop().animate({ scrollTop: scroll_to }, 400);
	}
}

function bar_progress(progress_line_object, direction) {
	var number_of_steps = progress_line_object.data('number-of-steps');
	var now_value = progress_line_object.data('now-value');
	var new_value = 0;
	if (direction == 'right') {
		new_value = now_value + (100 / number_of_steps);
	}
	else if (direction == 'left') {
		new_value = now_value - (100 / number_of_steps);
	}
	progress_line_object.attr('style', 'width: ' + new_value + '%;').data('now-value', new_value);
}

function notify(msg,className=''){
	Toastify({
	  text: msg,
	  duration: 3000,
	  newWindow: true,
	  close: true,
	  gravity: "top", 
	  positionLeft: false, 
	  className: className,
	  backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)",
	}).showToast();
};

$(document).ready(function () {


    /*
        Form
    */


	$('.f1 input[type="text"], .f1 input[type="password"], .f1 textarea, .f1 select').on('focus', function () {
		$(this).parent().removeClass('input-error');
	});

	// next step
	$('.request-wrap .clickable').on('click', function () {
		
		var parent_fieldset = $(this).parents('fieldset');
		var next_step = true;
		// navigation steps / progress steps
		var current_active_step = $(this).parents('.f1').find('.f1-step.active');
		var progress_line = $(this).parents('.f1').find('.f1-progress-line');

		if(parent_fieldset.hasClass('BrandFieldList')){
			requestBrandid = $(this).data('id');
			$('fieldset.GroupFieldList .clickable').addClass('stateOff');
			$.each(groupList[parseInt(requestBrandid)],function(key,value){
				$('fieldset.GroupFieldList').find('*[data-id="'+ key +'"]').removeClass('stateOff');
			});
			
		}

		if(parent_fieldset.hasClass('GroupFieldList')){
			requestGroupid = $(this).data('id');
			$('fieldset.ProductFieldList .clickable').addClass('stateOff');
			$.each(productList[parseInt(requestGroupid)],function(key,value){
				$('fieldset.ProductFieldList').find('*[data-id="'+ key +'"]').removeClass('stateOff');
			});
			$('.js-timeline-group').html($(this).find('h3').html());
		}
		if(parent_fieldset.hasClass('ProductFieldList')){
			requestProductid = $(this).data('id');
			$('.js-timeline-product').text($(this).find('h3').html());
		}
		if(parent_fieldset.hasClass('ServiceFieldList')){
			requestServiceid = $(this).data('id');
			$('.js-timeline-service').html($(this).find('h3').html());
		}
		
		// fields validation
		parent_fieldset.find('input[type="text"], input[type="password"], textarea').each(function () {
			if ($(this).val() == "") {
				$(this).addClass('input-error');
				next_step = false;
			}
			else {
				$(this).removeClass('input-error');
			}
		});
		// fields validation

		if (next_step) {
			parent_fieldset.fadeOut(400, function () {
				// change icons
				current_active_step.removeClass('active').addClass('activated').next().addClass('active');
				// progress bar
				bar_progress(progress_line, 'right');
				// show next step
				$(this).next().fadeIn();
				// scroll window to beginning of the form
				scroll_to_class($('.f1'), 20);
			});
		}

	});

	$('.f1 .f1-step').on('click', function(){
		let current_active_step = $(this).parents('.f1').find('.f1-step.active');
		let progress_line = $(this).parents('.f1').find('.f1-progress-line');
		var number_of_steps = progress_line.data('number-of-steps');
		
		if(current_active_step.data('step-number') <= $(this).data('step-number')){
			return false;
		}
		const new_value = $(this).data('step-number') * (100 / number_of_steps);
		let new_step = $(this);

		$('fieldset[data-step-number="'+ current_active_step.data('step-number') +'"]').fadeOut(400, function () {
			
			// change icons
			current_active_step.removeClass('active')
			new_step.removeClass('activated').addClass('active');
			// progress bar
			progress_line.attr('style', 'width: ' + new_value + '%;').data('now-value', new_value);
			// show previous step
			$('fieldset[data-step-number="'+ new_step.data('step-number') +'"]').fadeIn();
			// scroll window to beginning of the form
			scroll_to_class($('.f1'), 20);
		});

	})
	// previous step
	$('.f1 .btn-previous').on('click', function () {
		// navigation steps / progress steps
		var current_active_step = $(this).parents('.f1').find('.f1-step.active');
		var progress_line = $(this).parents('.f1').find('.f1-progress-line');

		$(this).parents('fieldset').fadeOut(400, function () {
			// change icons
			current_active_step.removeClass('active').prev().removeClass('activated').addClass('active');
			// progress bar
			bar_progress(progress_line, 'left');
			// show previous step
			$(this).prev().fadeIn();
			// scroll window to beginning of the form
			scroll_to_class($('.f1'), 20);
		});
	});


});
