<html dir="rtl">

<head>
    <style>
    body {
        font-family: zar;
        font-size: 10pt;
    }

    p {
        margin: 0pt;
    }

    table.items {
        border: 0.1mm solid #000000;
    }

    td {
        vertical-align: top;
    }

    .items td {
        border-left: 0.1mm solid #000000;
        border-right: 0.1mm solid #000000;
    }

    table thead td {
        background-color: #EEEEEE;
        text-align: center;
        border: 0.1mm solid #000000;
        font-variant: small-caps;
    }

    .items td.blanktotal {
        background-color: #FFFFFF;
        border: 0.1mm solid #000000;
    }

    .items td.totals {
        text-align: left;
        border-top: 0.1mm solid #000000;
        border-right: 0.1mm solid #000000;
    }

    .items td.cost {
        text-align: center;
    }

    .bold{
    	font-weight: bold;
    }

    .tableHeader{
        font-weight: bold;
        font-family: yakan!important;
        text-align: center;
        background-color: #5f5f5f;
        color:#ffffff!important;
        font-size: 15pt;
    }

    .tableBordered{
        font-weight: normal;
        font-family: yakan;
        text-align: right;
        font-size: 10pt;
        border: 1pt solid #000000;
        border-spacing: 0;
        margin-bottom: 5pt;
    }

    .tableBordered td{
        padding-top: 5pt;
        padding-bottom: 5pt;
    }

    </style>
</head>

<body>
    @foreach($invoices as $invoice)
    <div style="text-align: center">
        <img src="{{ public_path('eqlid/logo2.png') }}" width="130px" style="margin-bottom: 10px;">
    </div>
    <div style="text-align: center;font-weight: bold;font-size: 13pt;">فاکتور فروش  کالا و خدمات</div>

    <table width="100%" class="tableBordered" cellspacing="0">
        <tr>
            <td colspan="3" class="tableHeader" style="color:white;">
                مشخصات فروشنده
            </td>
            
        </tr>
        <tr>
            <td width="42%">
                <span class="tdTitle">نام فروشنده:</span>
               شرکت مشتریان گلدیران
            </td>
            <td width="33%">
                
            </td>
            <td width="25%">
               
            <span class="tdTitle">تاریخ :</span>
                {{FarsiLib::g2jDate($invoice->xinvoice_date,true)}}
            </td>
        </tr>
        <tr>
            <td width="50%">
                <span class="tdTitle">استان:</span>
                تهران
            </td>
            <td width="25%">
                <span class="tdTitle">شهرستان  :</span>
                تهران
            </td>
            <td width="25%">
                <span class="tdTitle">  کدپستی :</span>
                {{FarsiLib::convertDigit('1418693983')}}
            </td>
        </tr>
        <tr>
            <td width="50%">
                <span class="tdTitle">نشانی:</span>
                بزرگراه همت، بزرگراه باکری جنوب، اولین دسترسی محلی، خیابان مخابرات، کوچه رز،کوچه رضوان، پلاک ۱/۱
            </td>
            <td width="25%">
                <span class="tdTitle">تلفن  :</span>
                {{FarsiLib::convertDigit('02147300000')}}
            </td>
            <td width="25%">
                <span class="tdTitle">  نمابر :</span>
                  {{FarsiLib::convertDigit('02147300000')}}
            </td>
        </tr>
    </table>

    <table width="100%" class="tableBordered" cellspacing="0">
        <tr>
            <td colspan="3" class="tableHeader" style="color:white;">
                مشخصات  خریدار
            </td>
        </tr>
        <tr>
            <td width="42%">
                <span class="tdTitle">نام  خریدار:</span>
                {{$invoice->user->xname . ' ' . $invoice->user->xfamily}}
            </td>
            <td width="33%">
                <span class="tdTitle">شماره  سفارش :</span>
                {{FarsiLib::convertDigit($invoice->xinvoice_number)}}
            </td>
            <td width="25%">
                <span class="tdTitle">  شناسه ملی :</span>
                {{FarsiLib::convertDigit($invoice->user->xintcode)}}
            </td>
        </tr>
        <tr>
            <td width="50%">
                <span class="tdTitle">استان:</span>
                @if($invoice->province)
                    {{$invoice->province->name}}  
                @endif
            </td>
            <td width="25%">
                <span class="tdTitle">شهرستان  :</span>
                @if($invoice->county)
                    {{$invoice->county->name}}  
                @endif
            </td>
            <td width="25%">
                <span class="tdTitle">  کدپستی :</span>
                 {{FarsiLib::convertDigit($invoice->xinvoice_ads_postal_code)}}
            </td>
        </tr>
        <tr>
            <td width="50%">
                <span class="tdTitle">نشانی:</span>
                {{FarsiLib::convertDigit($invoice->xinvoice_ads_address)}}
            </td>
            <td width="25%">
                <span class="tdTitle">تلفن  :</span>
                {{FarsiLib::convertDigit($invoice->xinvoice_ads_phone)}}
            </td>
            <td width="25%">
                <span class="tdTitle">  نوع ارسال :</span>
                 @t($invoice->xinvoice_ship)
            </td>
        </tr>
    </table>

    <table class="items" width="100%" style="font-size: 9pt; border-collapse: collapse; " cellpadding="8">
        <thead>
            <tr>
                <td width="2%"> </td>
                <td width="30%">نام </td>
                <td width="15%">مبلغ واحد</td>
                <td width="13%">مبلغ تخفیف </td>
                <td width="15%">قیمت خالص واحد</td>
                <td width="6%">تعداد</td>
                <td width="19%">مبلغ کل</td>
            </tr>
        </thead>
        <tbody>
            <!-- ITEMS HERE -->
            @foreach(config('app.shop') == 'product' ? $invoice->Products : $invoice->books as $item)
            <tr>
                <td>{{FarsiLib::convertDigit($loop->iteration)}}</td>
                <td>{{config('app.shop') == 'product' ? $item->name : $item->xbook_title}}</td>
                <td>{{FarsiLib::faNormalizeNumber($item->pivot->xinvoiceitem_price)}}</td>
                <td>{{FarsiLib::faNormalizeNumber($item->pivot->xinvoiceitem_discount)}}</td>
                <td>{{FarsiLib::faNormalizeNumber($item->pivot->xinvoiceitem_price - $item->pivot->xinvoiceitem_discount)}}</td>
                <td>{{FarsiLib::faNormalizeNumber($item->pivot->xinvoiceitem_quantity)}}</td>
                <td>{{FarsiLib::faNormalizeNumber(((int)$item->pivot->xinvoiceitem_price - (int)$item->pivot->xinvoiceitem_discount) * (int)$item->pivot->xinvoiceitem_quantity)}}
                </td>
            </tr>
            @endforeach
            <!-- END ITEMS HERE -->
            <tr>
                <td class="bold totals" colspan="5">قیمت کل :</td>
                <td class="bold totals cost" colspan="2">{{FarsiLib::faNormalizeNumber($invoice->xinvoice_subtotal)}} تومان</td>
            </tr>
            <tr>
                <td class="bold totals" colspan="5">مجموع تخفیفات:</td>
                <td class="bold totals cost" colspan="2">{{FarsiLib::faNormalizeNumber($invoice->xinvoice_discount)}} تومان</td>
            </tr>
            <tr>
                <td class="bold totals" colspan="5">هزینه ارسال {{t($invoice->xinvoice_ship)}}:</td>
                <td class="bold totals cost" colspan="2">{{FarsiLib::faNormalizeNumber($invoice->xinvoice_ship_price)}} تومان</td>
            </tr>
            <tr>
                <td class="bold totals" colspan="5">  مبلغ کد تخفیف {{$invoice->xinvoice_copoun_code}}:</td>
                <td class="bold totals cost" colspan="2">{{FarsiLib::faNormalizeNumber($invoice->xinvoice_copoun_discount)}} تومان</td>
            </tr>
            <tr>
                <td class="bold totals" colspan="5"> جمع فاکتور: </td>
                <td class="bold totals cost" colspan="2">{{FarsiLib::faNormalizeNumber($invoice->xinvoice_total)}} تومان</td>
            </tr>
        </tbody>
    </table>
    
    @if(!$loop->last)
    <pagebreak>
        @endif
        @endforeach
</body>

</html>
