var Utility = {
    basketCounterElm: document.querySelector(".basket .badge"),
    itemOrginalPriceElm: '.cart-item .priceCol .price-del',
    itemDiscountPriceElm: '.cart-item .priceCol .price-discount',
    itemTotalPriceElm: '.cart-item .priceCol .price-total',
    summaryPriceSubtotalElm: document.querySelector('.cart-summary .summary-price-subtotal'),
    summaryPriceDiscountElm: document.querySelector('.cart-summary .summary-price-discount'),
    summaryPricePostElm: document.querySelector('.cart-summary .summary-price-post'),
    summaryPriceTotalElm: document.querySelector('.cart-summary .cart-summary-price-value'),
    summaryPriceDiscountTitleElm: document.querySelector('.cart-summary .summary-price-discount-title'),
    summaryPriceCopounElm: document.querySelector('.cart-summary .summary-price-copoun-discount'),
    priceTag: ' تومان ',

    dispatchEvent: function (event, data, element = null) {
        switch (event) {
            case 'cart.add': {
                Utility.notify('محصول با موفقیت اضافه شد.');
                Utility.updateBasketLogo(data);
                break;
            }

            case 'cart.update': {
                Utility.notify('محصول با موفقیت اضافه شد.');
                Utility.updateBasketLogo(data);
                Utility.updateItemPrice(data, element);
                Utility.updateSummaryPrice(data);
                break;
            }

            case 'cart.remove': {
                Utility.notify('محصول با موفقیت حذف شد');
                Utility.updateBasketLogo(data);
                Utility.updateSummaryPrice(data);
                break;
            }

            case 'cart.removeAll': {
                Utility.notify('سبد شما خالی شد');
                Utility.updateBasketLogo(data);
                Utility.updateSummaryPrice(data);
                break;
            }

            case 'cart.copoun.add': {
                Utility.notify('کد تخفیف  با موفقیت ثبت شد');
                Utility.updateSummaryPrice(data);
                break;
            }

            case 'cart.copoun.remove': {
                Utility.notify('کد تخفیف  با موفقیت  حذف شد');
                Utility.updateSummaryPrice(data);
                break;
            }
        }
    },

    updateItemPrice: function (data, element) {
        let parent = element.closest('.cart-item');
        var elm = parent.querySelector(Utility.itemOrginalPriceElm);
        if (elm) elm.innerHTML = (DigitHelper.writeNumber(data.itemSubtotal) + Utility.priceTag);

        elm = parent.querySelector(Utility.itemDiscountPriceElm);
        if (elm) elm.innerHTML = (DigitHelper.writeNumber(data.itemDiscountTotal) + Utility.priceTag);

        elm = parent.querySelector(Utility.itemTotalPriceElm);
        if (elm) elm.innerHTML = (DigitHelper.writeNumber(data.itemTotal) + Utility.priceTag);
    },

    updateSummaryPrice: function (data) {
        Utility.summaryPriceSubtotalElm.innerHTML = DigitHelper.writeNumber(data.subtotal) + Utility.priceTag;
        Utility.summaryPriceDiscountElm.innerHTML = DigitHelper.writeNumber(data.discount) + Utility.priceTag;
        let textDiscount = 'تخفیف';
        if (data.discountDetail.accepted == 'extra')
            textDiscount = 'تخفیف خرید اینترنتی';
        if (data.discountDetail.accepted == 'copoun')
            textDiscount = 'مبلغ کد تخفیف';
        if (data.discountDetail.accepted == 'festivalDiscount')
            textDiscount = 'تخفیف جشنواره';

        Utility.summaryPriceDiscountTitleElm.innerHTML = textDiscount;
        let text = 'ارسال رایگان';
        if (data.post > 0)
            text = DigitHelper.writeNumber(data.post) + Utility.priceTag;

        if (data.postMethod != 'unknown')
            Utility.summaryPricePostElm.innerHTML = text;
        else
            Utility.summaryPricePostElm.innerHTML = 'نامشخص';

        Utility.summaryPriceTotalElm.innerHTML = (DigitHelper.writeNumber(data.total) + Utility.priceTag);
    },

    updateBasketLogo: function (data) {
        Utility.basketCounterElm.innerHTML = DigitHelper.writeNumber(data.count);
    },

    notify: function (msg, className = '') {
        try {
            Toastify({
                text: msg,
                duration: 2000,
                newWindow: true,
                close: true,
                gravity: "top",
                positionLeft: false,
                className: className,
            }).showToast();
        } catch (error) {

        }
    },

    total: function () {
        let total = 0
        for (let pdtId in items) {
            total += catalog.products.find(pdt => {
                return pdt.id == pdtId
            }).price * items[pdtId]
        }

        return total
    },

    sendAjax: function (data, url, success, failed, type = 'POST') {
        var xmlhttp = new XMLHttpRequest();
        xmlhttp.onreadystatechange = function () {
            if (xmlhttp.readyState === XMLHttpRequest.DONE) {
                var status = xmlhttp.status;
                if (status === 0 || (status >= 200 && status < 400)) {
                    success(xmlhttp.responseText);
                } else {
                    failed(xmlhttp.responseText)
                }
            }
        }
        xmlhttp.open(type, url, true);
        xmlhttp.setRequestHeader('X-CSRF-TOKEN', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));
        xmlhttp.setRequestHeader('Content-type', 'application/json');
        xmlhttp.send(JSON.stringify(data));

    },

    triggerEvent: function (el, type) {
        // IE9+ and other modern browsers
        if ('createEvent' in document) {
            var e = document.createEvent('HTMLEvents');
            e.initEvent(type, false, true);
            el.dispatchEvent(e);
        } else {
            // IE8
            var e = document.createEventObject();
            e.eventType = type;
            el.fireEvent('on' + e.eventType, e);
        }
    }
};

String.prototype.commaSeparator = function () {
    return this.commaSeparatorClean().replace(/\B(?=(\d{3})+(?!\d))/g, ",")
};

String.prototype.commaSeparatorClean = function () {
    return this.replace(/,/g, "")
};

var DigitHelper = {
    convertDigit: function (num, type) {
        type = type ? type : 'en';
        if (type == 'en') {
            num = String(num);
            num = (num).replace(/٫/g, '.');
            num = (num).replace(/۰/g, '0');
            num = (num).replace(/۱/g, '1');
            num = (num).replace(/۲/g, '2');
            num = (num).replace(/۳/g, '3');
            num = (num).replace(/۴/g, '4');
            num = (num).replace(/۵/g, '5');
            num = (num).replace(/۶/g, '6');
            num = (num).replace(/۷/g, '7');
            num = (num).replace(/۸/g, '8');
            num = (num).replace(/۹/g, '9');
            num = (num).replace(/٤/g, '4');
            num = (num).replace(/٥/g, '5');
            num = (num).replace(/٦/g, '6');
        } else if (type == 'fa') {
            num = String(num);
            num = (num).replace(/0/g, '۰');
            num = (num).replace(/1/g, '۱');
            num = (num).replace(/2/g, '۲');
            num = (num).replace(/3/g, '۳');
            num = (num).replace(/4/g, '۴');
            num = (num).replace(/5/g, '۵');
            num = (num).replace(/6/g, '۶');
            num = (num).replace(/7/g, '۷');
            num = (num).replace(/8/g, '۸');
            num = (num).replace(/9/g, '۹');
        }
        return num;
    },

    removeCommasNumber: function (num) {
        if (typeof num != 'string')
            return false;
        num = num.replace(/[,]+/g, '');
        if (!num) num = '0';
        return num;
    },

    addCommasNumber: function (nStr) {
        nStr += '';
        const x = nStr.split('.');
        let x1 = x[0];
        let x2 = x.length > 1 ? '.' + x[1] : '';
        let rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + ',' + '$2');
        }
        return x1 + x2;
    },

    readNumber: function (number) {
        return parseFloat(this.convertDigit(this.removeCommasNumber(number)));
    },

    writeNumber: function (number) {
        return this.convertDigit(this.addCommasNumber(number), 'fa');
    },


    IsValidNationalCode: function (code) {
        var L = code.length;

        if (L < 8 || parseInt(code, 10) == 0) return false;
        code = ('0000' + code).substr(L + 4 - 10);
        if (parseInt(code.substr(3, 6), 10) == 0) return false;
        var c = parseInt(code.substr(9, 1), 10);
        var s = 0;
        for (var i = 0; i < 9; i++)
            s += parseInt(code.substr(i, 1), 10) * (10 - i);
        s = s % 11;
        return (s < 2 && c == s) || (s >= 2 && c == (11 - s));
        return true;
    }
}
