var Shipping = {
    addressRadio: document.querySelectorAll(".addresRadio"),
    currentShipElm: document.querySelector(".current-ship"),
    changeLocationElm: 'btn-change-location',
    createLocationElm: 'js-add-address-btn',
    radioTemplate: document.querySelectorAll('.js-radio-div'),
    currentTitle: '.js-ship-title',
    currentName: '.js-ship-name',
    currentMobile: '.js-ship-mobile',
    currentPostalCode: '.js-ship-postalcode',
    currentAddress: '.js-ship-address',
    shipModalElm: document.querySelector('#changeAddressModal'),
    modalTitleElm: document.querySelector('#f-titleAddress'),
    modalMobileElm: document.querySelector('#f-mobileAddress'),
    modalAddressElm: document.querySelector('#f-valueAddress'),
    modalNameElm: document.querySelector('#f-name'), //
    modalProvinceElm: document.querySelector('#provinceListCombo'),
    modalCityElm: document.querySelector('#cityListCombo'),
    modalRegionElm: document.querySelector('#regionListCombo'),
    modalParishElm: document.querySelector('#parishListCombo'),
    modalPostalCodeElm: document.querySelector('#f-postalCode'), //
    modalTitle: document.querySelector('#f-modal-title'),
    modalIdElm: document.querySelector('#f-idAddress'),
    modalSubmitElm: document.querySelector('#f-submitAddress'),
    postCheckBox: document.querySelectorAll("input[name='bikePostName']"),
    summaryPriceSubtotalElm: document.querySelector('.cart-summary .summary-price-subtotal'),
    summaryPriceDiscountElm: document.querySelector('.cart-summary .summary-price-discount'),
    summaryPricePostElm: document.querySelector('.cart-summary .summary-price-post'),
    summaryPriceTotalElm: document.querySelector('.cart-summary .cart-summary-price-value'),
    summaryPriceCopounElm: document.querySelector('.cart-summary .summary-price-copoun-discount'),
    approveBtn: document.querySelector(".shipping-wrapper .approveBtn"),
    priceTag: ' تومان ',

    init: function () {
        if (Shipping.addressRadio) {
            for (var i = 0; i < Shipping.addressRadio.length; i++) {
                Shipping.addressRadio[i].addEventListener("change", (event) => {
                    console.log('ss');
                    Shipping.radioChanged(event)
                });
            }
        }

        if (Shipping.postCheckBox) {
            for (var i = 0; i < Shipping.postCheckBox.length; i++) {
                Shipping.postCheckBox[i].addEventListener("change", (event) => {
                    Shipping.postCheckboxChanged(event)
                });
            }
        }

        if (document.querySelector('input[name=customRadio]:checked')) {
            const customRadio = document.querySelector('input[name=customRadio]:checked').getAttribute('data-address');
            const address = JSON.parse(customRadio);
            if (address.city != 1) {
                document.querySelector("#bike-post").setAttribute('disabled', true);
                document.querySelector("#normal-post").setAttribute('disabled', false);
                document.querySelector("#bike-post").setAttribute("checked", false);
                document.querySelector("#normal-post").setAttribute("checked", true);
                Shipping.postCheckboxChanged();
            } else {
                document.querySelector("#normal-post").setAttribute('disabled', true);
                document.querySelector("#bike-post").setAttribute('disabled', false);
                document.querySelector("#normal-post").setAttribute("checked", false);
                document.querySelector("#bike-post").setAttribute("checked", true);
                Shipping.postCheckboxChanged();
            }
        }

        if (Shipping.shipModalElm) {
            Shipping.shipModalElm.addEventListener('modal-show', (event) => {
                
                const button = event.detail.relatedTarget;
                const modal = event.currentTarget;
                
                if (button.classList.contains(Shipping.changeLocationElm)) {
                    const dataField = document.querySelector('input[name=customRadio]:checked').getAttribute('data-address');
                    const address = JSON.parse(dataField)

                    modal.querySelector("#"+Shipping.modalTitle.id).innerHTML = ('تغییر اطلاعات آدرس');
                    modal.querySelector("#"+Shipping.modalTitleElm.id).value = (address.title)
                    modal.querySelector("#"+Shipping.modalMobileElm.id).value = (address.mobile)
                    modal.querySelector("#"+Shipping.modalAddressElm.id).value = (address.address)
                    modal.querySelector("#"+Shipping.modalNameElm.id).value = (address.name)
                    var temp = modal.querySelector("#"+Shipping.modalProvinceElm.id);
                    temp.querySelector('option[value="' + address.province + '"]').setAttribute('selected', true);
                    Utility.triggerEvent(temp,'change');

                    temp = modal.querySelector("#"+Shipping.modalCityElm.id);
                    temp.querySelector('option[value="' + address.city + '"]').setAttribute('selected', true);
                    Utility.triggerEvent(temp,'change');
                    
                    temp = modal.querySelector("#"+Shipping.modalRegionElm.id);
                    temp.querySelector('option[value="' + address.region + '"]').setAttribute('selected', true)
                    Utility.triggerEvent(temp,'change');

                    temp = modal.querySelector("#"+Shipping.modalParishElm.id).querySelector('option[value="' + address.parish + '"]')
                    temp.setAttribute('selected', true);

                    modal.querySelector("#"+Shipping.modalPostalCodeElm.id).value = (address.postalCode)

                    const id = document.querySelector('input[name=customRadio]:checked').getAttribute('data-id');
                    modal.querySelector("#"+Shipping.modalIdElm.id).value = id;
                } else if (button.classList.contains(Shipping.createLocationElm)) {
                    modal.querySelector("#"+Shipping.modalTitle.id).innerHTML = 'ایجاد آدرس جدید';
                    modal.querySelector("#"+Shipping.modalTitleElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalMobileElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalAddressElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalNameElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalProvinceElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalCityElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalRegionElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalParishElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalPostalCodeElm.id).value = '';
                    modal.querySelector("#"+Shipping.modalIdElm.id).value = 0;
                }

            });
        }

        if (Shipping.modalSubmitElm) {
            Shipping.modalSubmitElm.addEventListener("click", (event) => {
                event.preventDefault();
                const title = Shipping.modalTitleElm.value.trim()
                const mobile = Shipping.modalMobileElm.value.trim()
                const address = Shipping.modalAddressElm.value.trim()
                const name = Shipping.modalNameElm.value.trim()
                const province = Shipping.modalProvinceElm.value
                const city = Shipping.modalCityElm.value
                const region = Shipping.modalRegionElm.value
                const parish = Shipping.modalParishElm.value
                const postalCode = Shipping.modalPostalCodeElm.value.trim()

                if (title == '' || title.length == 0) {
                    Utility.notify('عنوان آدرس باید وارد شود', 'danger');
                    return false;
                }
                if (mobile == '' || mobile.length != 11) {
                    Utility.notify('شماره تماس 11 رقمی باید وارد شود', 'danger');
                    return false;
                }
                if (address == '' || address.length == 0) {
                    Utility.notify('آدرس به درستی وارد نشده است', 'danger');
                    return false;
                }
                if (name == '' || name.length == 0) {
                    Utility.notify('ثبت اطلاعات نام گیرنده الزامی می باشد.', 'danger');
                    return false;
                }
                if (province == '' || province.length == 0) {
                    Utility.notify('استان به درستی وارد نشده است', 'danger');
                    return false;
                }
                if (city == null || city == '' || city.length == 0) {
                    Utility.notify('شهر به درستی وارد نشده است', 'danger');
                    return false;
                }

                if (region == null || region == '' || region.length == 0) {
                    Utility.notify('منطقه به درستی وارد نشده است', 'danger');
                    return false;
                }
                if (parish == null || parish == '' || parish.length == 0) {
                    Utility.notify('محله به درستی وارد نشده است', 'danger');
                    return false;
                }
                if (postalCode == '' || postalCode.length != 10 ) {
                    Utility.notify('کد پستی به درستی وارد نشده است', 'danger');
                    return false;
                }

                Shipping.sendUpdateAddressAjax();
                var modalCloseBtn = Shipping.shipModalElm.querySelector('.js-modal-close');
                Utility.triggerEvent(modalCloseBtn,'click');
              
            });
        }

        if (Shipping.approveBtn) {
            Shipping.approveBtn.addEventListener("click", (event) => {
                event.preventDefault();

                const address = document.querySelector('input[name=customRadio]:checked').getAttribute('data-id');
                const post = document.querySelector('input[name=bikePostName]:checked').value;

                if (!address) {
                    Utility.notify('آدرس ارسالی به درستی مشخص نشده است.');
                    return false;
                }

                if (!post) {
                    Utility.notify('نحوه ارسال مشخص نشده است');
                    return false;
                }

                let name, family, intcode;

                const nameInfo = document.querySelector('input[name=userInfo-name]');
                const familyInfo = document.querySelector('input[name=userInfo-family]');
                const intcodeInfo = document.querySelector('input[name=userInfo-intcode]');
                if (nameInfo) {
                    name = nameInfo.value;
                    if (!name) {
                        Utility.notify('در قسمت مشخصات شما، نام وارد نشده است');
                        return false;
                    }
                }
                if (familyInfo) {
                    family = familyInfo.value;
                    if (!family) {
                        Utility.notify('در قسمت مشخصات شما، نام خانوادگی وارد نشده است');
                        return false;
                    }
                }
                if (intcodeInfo) {
                    intcode = intcodeInfo.value;
                    if (!intcode) {
                        Utility.notify('در قسمت مشخصات شما، کد ملی وارد نشده است');
                        return false;
                    }
                    const isValidNC = DigitHelper.IsValidNationalCode(intcode);
                    if (!isValidNC) {
                        Utility.notify('در قسمت مشخصات شما، کد ملی صحیح نیست');
                        return false;
                    }
                }

                document.querySelector('#h-address').value = (address);
                document.querySelector('#h-post').value = (post);
                //document.querySelector('#h-bank').value = bank;
                document.querySelector('#h-userInfo').value = (name ? JSON.stringify({
                    name: name,
                    family: family,
                    intcode: intcode
                }) : null);

                var shippingForm = document.querySelector('#shippingForm');
                shippingForm.setAttribute('action', "/Payment");
                shippingForm.submit();
            });
        }

    },

    radioChanged: function (event) {
        event.preventDefault();
        if (event.currentTarget.checked) {
            const address = JSON.parse(event.currentTarget.getAttribute('data-address'))
            Shipping.changePostMethodAuto(address.city != 1, event);

            let id = event.currentTarget.getAttribute("data-id");
            Shipping.changeAddressAjax(event.currentTarget, id);
        }
    },

    changePostMethodAuto: function (isNormalPost, event) {
        if (isNormalPost) {
            document.querySelector("#bike-post").setAttribute('disabled', true);
            document.querySelector("#normal-post").setAttribute('disabled', false);
            document.querySelector("#bike-post").checked = false;
            document.querySelector("#normal-post").checked = true;
        } else {
            document.querySelector("#normal-post").setAttribute('disabled', true);
            document.querySelector("#bike-post").setAttribute('disabled', false);
            document.querySelector("#normal-post").checked = false;
            document.querySelector("#bike-post").checked = true;
        }
        Shipping.postCheckboxChanged(event);
    },

    postCheckboxChanged: function (event) {
        if (event)
            event.preventDefault();

        const isBikePost = document.querySelector("input[name='bikePostName']:checked").value;
        const address = JSON.parse(document.querySelector('input[name=customRadio]:checked').getAttribute('data-address'))
        if (isBikePost == 'bikePost') {
            if (parseInt(address.city) == 1)
                Shipping.changePostMethod(isBikePost)
            else {
                Utility.notify('ارسال بوسیله پیک فقط در شهر تهران قابل انتخاب است', 'danger');
            }
        } else {
            if (parseInt(address.city) != 1)
                Shipping.changePostMethod(isBikePost)
            else {
                Utility.notify('ارسال بوسیله پست پیشتاز فقط در شهرستان ها قابل انتخاب است', 'danger');
            }

        }
    },

    sendUpdateAddressAjax: function () {
        const data = {
            id: Shipping.modalIdElm.value,
            title: Shipping.modalTitleElm.value,
            mobile: Shipping.modalMobileElm.value,
            address: Shipping.modalAddressElm.value,
            name: Shipping.modalNameElm.value,
            province: Shipping.modalProvinceElm.value,
            city: Shipping.modalCityElm.value,
            region: Shipping.modalRegionElm.value,
            parish: Shipping.modalParishElm.value,
            postalCode: Shipping.modalPostalCodeElm.value
        }

        function done(event) {
            if (data.id == '0') {
                
                if (Shipping.radioTemplate.length == 0)
                    location.reload();
                let newObj = Shipping.radioTemplate[0].cloneNode(true);
                
                newObj.querySelector('input').setAttribute('id', 'customRadio' + JSON.parse(event).id)
                newObj.querySelector('input').setAttribute('data-id', JSON.parse(event).id)
                newObj.querySelector('input').setAttribute('data-address', event)
                newObj.querySelector('label').setAttribute('for', 'customRadio' + JSON.parse(event).id)
                newObj.querySelector('label').innerText = (data.title)
                let parent = Shipping.radioTemplate[0].parentNode;
                parent.prepend(newObj);
            } else {
                document.querySelector('input[name=customRadio]:checked').parentNode.querySelector('label').innerText = JSON.parse(event).title;
                document.querySelector('input[name=customRadio]:checked').setAttribute('data-address', event)
            }
            Shipping.dispatchEvent('ship.update', JSON.parse(event));
            Utility.triggerEvent(Shipping.addressRadio,'change');
        };

        function fail(event) {
            Utility.notify(JSON.parse(event.responseText).msg, 'danger');
        };

        Utility.sendAjax({
            data: data
        }, '/Shipping/update', done, fail);
    },

    changePostMethod: function (isBikePost) {

        function done(event) {
            Shipping.dispatchEvent('ship.post.change', JSON.parse(event));
        };

        function fail(event) {
            Utility.notify('خطا  در برقراری ارتباط', 'danger');
        };

        Utility.sendAjax({
            postMethod: isBikePost
        }, '/Shipping/changePostMethod', done, fail);
    },

    changeAddressAjax: function (element, id) {

        function done(event) {
            Shipping.dispatchEvent('ship.change', JSON.parse(event));
        };

        function fail(event) {
            Utility.notify('خطا  در برقراری ارتباط', 'danger');
        };

        Utility.sendAjax({
            id: id
        }, '/Shipping/change', done, fail);
    },

    dispatchEvent: function (event, data, element = null) {
        switch (event) {
            case 'ship.change': {
                Utility.notify('آدرس دریافت تغییر کرد');
                Shipping.updateCurrentLocation(data);
                break;
            }

            case 'ship.update': {
                Utility.notify('آدرس با موفقیت تغییر پیدا کرد');
                Shipping.updateCurrentLocation(data);
                break;
            }

            case 'ship.post.change': {
                Utility.notify('نحوه ارسال مرسوله تغییر یافت');
                Shipping.updateSummaryPriceShipping(data);
                break;
            }
        }
    },

    updateCurrentLocation: function (data) {
        Shipping.currentShipElm.querySelector(Shipping.currentName).innerHTML = (data.name);
        Shipping.currentShipElm.querySelector(Shipping.currentMobile).innerHTML = (DigitHelper.convertDigit(data.mobile, 'fa'));
        Shipping.currentShipElm.querySelector(Shipping.currentPostalCode).innerHTML = (DigitHelper.convertDigit(data.postalCode, 'fa'));
        Shipping.currentShipElm.querySelector(Shipping.currentAddress).innerHTML = (data.address);
    },

    updateSummaryPriceShipping: function (data) {

        Shipping.summaryPriceSubtotalElm.innerHTML = (DigitHelper.writeNumber(data.subtotal) + Shipping.priceTag);
        Shipping.summaryPriceDiscountElm.innerHTML = (DigitHelper.writeNumber(data.discount) + Shipping.priceTag);
        let text = 'ارسال رایگان';
        if (data.post > 0)
            text = DigitHelper.writeNumber(data.post) + Shipping.priceTag;
        if (data.postMethod == 'unknown')
            text = 'نامشخص'
        else if (data.postStatus == 2 || data.postStatus == 3)
            text = 'پس کرایه'

        Shipping.summaryPricePostElm.innerHTML = (text);

        if (Shipping.summaryPriceCopounElm)
            Shipping.summaryPriceCopounElm.innerHTML = (DigitHelper.writeNumber(data.copounDiscount) + Shipping.priceTag);
        Shipping.summaryPriceTotalElm.innerHTML = (DigitHelper.writeNumber(data.total) + Shipping.priceTag);
    }
}
