@section('content')

<section>
    <div class="container shipping-wrapper">
        @if (session()->has('success_message'))
            <div class="alert alert-success">
                {{ session()->get('success_message') }}
            </div>
        @endif

        @if(count($errors) > 0)
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        @include('cart::index.cartSteps',['cart' => 'is-completed','ship'=>'is-active','payment'=>''])
        <div class="row">
            <div class="col-12 col-md-8">
                @if(Auth::user()->isIncompleteInfo())
                    @include('cart::index.incompleteInfo')
                @endif
                @include('cart::index.shippingAddress')
                @if(config('cart.post.status'))
                    @include('cart::index.postMethod')
                @endif
            </div>
            <div class="col-12 col-md-4">
               @include('cart::index.cartSummary',['btnTitle' => 'تائید و ادامه سفارش'])
            </div>
        </div>
    </div>
</section>
<form method="post" id="shippingForm">
  @csrf
  <input type="hidden" name="address" id="h-address" value="">
  <input type="hidden" name="payment" id="h-payment" value="">
  <input type="hidden" name="post" id="h-post" value="0">
  <input type="hidden" name="bank" id="h-bank" value="mellat">
  <input type="hidden" name="userInfo" id="h-userInfo" value="">
</form>
@endsection

@section('modals')
  @include('cart::index.addressModal',['submitId' => 'f-submitAddress'])
@endsection

@section('extra-js')
    
@endsection
