function setSubGroup(objData, first, group1, group2, group3, selected, titleOfSelect) {
    var src = group1
    var des = group2;
    var src2 = group3;
    var first = first ? first : 0;

    if (!src.length || !des.length || !objData) return;

    var desType = (typeof src.getAttribute('data-destype') != 'undefined' ? src.getAttribute('data-destype') : 'option');
    var desName = (typeof src.getAttribute('data-desname') != 'undefined' ? src.getAttribute('data-desname') : 'chk');

    if (des.getAttribute('data-advancedselect')) {
        des.parentNode.querySelector('.select2-container').remove();
    }

    var data = {};

    if (typeof src.value == 'object' && desType == 'option' && Object.keys(src.value).length != 0) {
        src.value.forEach(function (val,key) {
            var text = (src.querySelectorAll('option[value="' + val + '"]').length ? src.querySelectorAll('option[value="' + val + '"]').first().text() : val);
            data[text] = objData[val];
        });
    } else if (src.value) {
        if (src2 && src2.value)
            data = objData[src.value][src2.value];
        else
            data = objData[src.value];
    } else {
        objData.forEach(function (val, key) {
            if (typeof val == 'object' && Object.keys(val).length != 0) {
                val.forEach(function (k, v) {
                    data[k] = v;
                });
            } else {
                data[key] = val;
            }
        });
    }

    switch (desType) {
        case 'checkbox':
            des.empty();
            if (typeof data == 'undefined' || data.length == 0) {
                if (des.getAttribute('data-advancedselect') != undefined) {
                    App.setSelect2(des);
                }
                return;
            };
            if (typeof data == 'object') {
                data.forEach(function (val, key) {
                    var id = desName + key;
                    des.append('<input id="' + id + '" type="checkbox" name="' + desName +
                        '[]" value="' + val + '"' + (src.getAttribute('data-checkall') != undefined ? 'checked="checked"' : '') +
                        '>&nbsp;<label data-value="' + val + '">' + App.convertDigit(key, lang) + '</label>&nbsp;&nbsp;');
                });
            }
            break;
        default:
            des.querySelectorAll('option, optgroup').forEach(function (key) {
                
                if (key.value >= first) key.remove();
            });
            if (typeof data == 'undefined' || data.length == 0) {
                if (des.getAttribute('data-advancedselect') != undefined) {
                    App.setSelect2(des);
                }
                return;
            };
            if (typeof data == 'object') {
                if (titleOfSelect && typeof titleOfSelect != 'undefined') {
                    opt = createOption(0,titleOfSelect,true)
                    des.appendChild(opt);
                }

                Object.entries(data).forEach(function (value) {
                    var key = value[0], val=value[1];
                    var opt = null;
                    
                    if (typeof val == 'object' && Object.keys(val).length != 0) {
                        opt = createOption(key,val['title'])
                        des.appendChild(opt);
                    } else if (typeof val != 'object') {
                        if (key != 'title') {
                            opt = createOption(key,val)
                            des.appendChild(opt);
                        }
                    }
                });
            }
            
            des.querySelectorAll('option').forEach(function (val) {
                if (val.value == src.getAttribute('data-selected') || (typeof selected != 'undefined' && val.value == selected)) {
                    val.setAttribute('selected', 'selected');
                }
            });
            break;

    }

    if (des.getAttribute('data-advancedselect') != undefined) {
        App.setSelect2(des);
    }
}

function createOption(key,value,disable=false) {
    const newOption = document.createElement('option');
    const optionText = document.createTextNode(value);
    newOption.appendChild(optionText);
    newOption.setAttribute('value', key);
    if(disable){
        newOption.setAttribute('disabled','disabled');
    }
    return newOption;
}

function handleChangeProvince() {
    var provinceCL = document.querySelector('#provinceListCombo'),
        cityCL = document.querySelector('#cityListCombo'),
        regionCL = document.querySelector('#regionListCombo'),
        parishCL = document.querySelector('#parishListCombo');

    if(provinceCL)
    provinceCL.addEventListener('change', function () {
        setSubGroup(cityList, 0, provinceCL, cityCL, null, cityCL.value || 0, 'شهر');
    });

    if(cityCL)
    cityCL.addEventListener('change', function () {
        setSubGroup(regionList, 0, cityCL, regionCL, null, regionCL.value || 0, 'منطقه');
    });

    if(regionCL)
    regionCL.addEventListener('change', function () {
        setSubGroup(parishList, 0, regionCL, parishCL, null, parishCL.value || 0, 'محله');
    });

    if (provinceCL && parseInt(provinceCL.value)) Utility.triggerEvent(provinceCL,'change'); 
    if (cityCL && parseInt(cityCL.value)) Utility.triggerEvent(cityCL,'change'); 
    if (regionCL && parseInt(regionCL.value)) Utility.triggerEvent(regionCL,'change'); 
}

handleChangeProvince();
