@section('content')

<section>
    <div class="container preview-wrapper">
        @if (session()->has('success_message'))
            <div class="alert alert-success">
                {{ session()->get('success_message') }}
            </div>
        @endif

        @if(count($errors) > 0)
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @include('cart::index.cartSteps',['cart' => 'is-completed','ship'=>'is-completed','payment'=>'is-active'])
        <div class="row">
            <div class="col-12 col-md-8">
                @include('cart::index.paymentMethod')
                @include('cart::index.shippingCopoun')
                {{-- @include('cart::index.shippingItems')
                @include('cart::index.previewPostMethod') --}}
            </div>
            <div class="col-12 col-md-4">
               @include('cart::index.cartSummary',['btnTitle' => Cart::getPaymentMethod() == 'onlinePayment' ? 'تائید و اتصال به درگاه بانکی' : 'تائید و ثبت نهایی سفارش'])
            </div>
        </div>
    </div>
</section>
<form method="post" id="paymentForm">
  @csrf
  <input type="hidden" name="bank" id="h-bank" value="mellat">
</form>
@endsection


@section('extra-js')

@endsection
