<div class="payment-method-section items-section">
    <h4 class="cart-list-title"> شیوه پرداخت</h4>
    <div class="cart-list cart-list-box ship-payment-method">

        @if(config('cart.payment.method.online'))
        <div class="col-12 p-item-col">
            <div class="cart-list_content">
                <div class="payment-item font-icon payment-online">
                    <div class="custom-control custom-radio">
                        <input type="radio" id="payment-option-1" name="paymentRadio" class="custom-control-input" value="onlinePayment" @if(Cart::getPaymentMethod()=='onlinePayment' || Cart::getPaymentMethod()==null) checked="checked" @endif>
                        <label class="custom-control-label" for="payment-option-1">
                        <svg xmlns="http://www.w3.org/2000/svg" height="36px" viewBox="0 0 24 24" width="36px" fill="currentColor"><path d="M0 0h24v24H0z" fill="none"/><path d="M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zm0 14H4v-6h16v6zm0-10H4V6h16v2z"/></svg>
                        </label>
                    </div>
                    <h4 class="payment-title">
                        پرداخت اینترنتی ( آنلاین با تمامی کارت‌های بانکی )
                        <span>سرعت بیشتر در ارسال و پردازش سفارش </span>
                    </h4>
                </div>
                <div class="payment-bank  align-items-center">
                    <div class="payment-bank-item d-flex align-items-center is-selected" data-bank="mellat">
                        <img src="/images/mellat.png">

                    </div>
                    <!-- <div class="payment-bank-item ml-2 d-flex align-items-center" data-bank="fanava">
                    <img src="/images/fanava.png">
                    
                </div> -->
                </div>
            </div>
        </div>
        @endif
        @var('currentUser',Auth::user())
        @var('totalCart', Cart::totalAll()['total'])
        @if($currentUser && $currentUser->agent)
        <div class="col-12 p-item-col">
            <div class="cart-list_content">
                <div class="payment-item font-icon payment-offline">
                    <div class="custom-control custom-radio">
                        <input type="radio" id="payment-option-2" name="paymentRadio" class="custom-control-input" value="agentPayment" @if( $totalCart> ((int)$currentUser->agent->xgrand_price - (int)$currentUser->agent->xgrand_consumed) || date('Y-m-d h:i:s') > date('Y-m-d h:i:s', strtotime($currentUser->agent->expaire_at))) disabled @endif @if(Cart::getPaymentMethod() == 'agentPayment') checked="checked" @endif>
                        <label class="custom-control-label" for="payment-option-2">
                            <i class="icon-offline-payment"></i>
                        </label>
                    </div>
                    <h4 class="payment-title">
                        استفاده از اعتبار نمایندگی
                        <span>اعتبار شما
                            {{FarsiLib::faNormalizeNumber((int)$currentUser->agent->xgrand_price - (int)$currentUser->agent->xgrand_consumed)}}
                            تومان تا تاریخ
                            {{FarsiLib::g2jDate($currentUser->agent->expaire_at,true)}}
                            می باشد.
                        </span>
                    </h4>
                </div>
            </div>
        </div>
        @endif

        @if(config('cart.payment.method.cart'))
        <div class="col-12 p-item-col">
            <div class="cart-list_content">
                <div class="payment-item font-icon payment-offline">
                    <div class="custom-control custom-radio">
                        <input type="radio" id="payment-option-3" name="paymentRadio" class="custom-control-input" value="cartPayment" @if(Cart::getPaymentMethod()=='cartPayment' ) checked="checked" @endif>
                        <label class="custom-control-label" for="payment-option-3">
                            <i class="icon-offline-payment"></i>
                        </label>
                    </div>
                    <h4 class="payment-title">
                        پرداخت با کارت بانکی
                        <span>پرداخت کارت با کارت به شماره های بانکی شرکت چاپ و نشر
                        </span>
                        <div class="row align-items-center mt-2 pl-3">
                            <div class="mr-2 d-flex align-items-center">
                                <input type="text" name="paymentCartNumber" style="width: 100%" placeholder="4 رقم آخر کارت بانکی">
                            </div>
                            <div class="mr-2 d-flex align-items-center">
                                <input type="text" name="paymentRefNumber" style="width: 100%" placeholder="شماره پیگیری">
                            </div>
                        </div>
                    </h4>
                </div>
            </div>
        </div>
        @endif

        @if(config('cart.payment.method.offline'))
        <div class="col-12 p-item-col">
            <div class="cart-list_content">
                <div class="payment-item font-icon payment-offline">
                    <div class="custom-control custom-radio">
                        <input type="radio" id="payment-option-2" name="paymentRadio" class="custom-control-input" value="offlinePayment" @if(Cart::getPaymentMethod()=='offlinePayment' ) checked="checked" @endif>
                        <label class="custom-control-label" for="payment-option-2">
                            <i class="icon-offline-payment"></i>
                        </label>
                    </div>
                    <h4 class="payment-title">
                        پرداخت در محل با کارت بانکی
                        <span>پرداخت در هنگام تحویل سفارش با تمامی کارت‌های بانکی عضو شبکه شتاب
                        </span>
                    </h4>
                </div>
            </div>
        </div>
        @endif

    </div>
</div>