var Payment = {
    approveBtn: document.querySelector(".preview-wrapper .approveBtn"),
    bankElm: document.querySelector(".payment-bank-item"),
    bank: "",
    init: function () {
        if (Payment.approveBtn) {
            Payment.approveBtn.addEventListener("click", (event) => {
                event.preventDefault();
                const payment = document.querySelector('input[name=paymentRadio]:checked').value;

                if (!payment) {
                    Utility.notify(' شیوه پرداخت به درستی مشخص نشده است.');
                    return false;
                }

                let url = "";
                if (payment == 'onlinePayment')
                    url = '/payment/onlinePayment';
                else if (payment == 'offlinePayment')
                    url = '/payment/offlinePayment';
                else if (payment == 'agentPayment')
                    url = '/payment/agentPayment';
                else if (payment == 'cartPayment')
                    url = '/payment/cartPayment';
                else if (payment == 'digitalPayment')
                    url = '/payment/digitalPayment';
                else
                    url = 'payment/onlinePayment';

                document.querySelector('#h-bank').value = (Payment.bank ? Payment.bank : 'mellat');
                var paymentForm = document.querySelector('#paymentForm');
                paymentForm.setAttribute('action', url);
                paymentForm.submit();

            });
        }

        if (Payment.bankElm) {
            Payment.bankElm.addEventListener("click", (event) => {
                event.preventDefault();
                for (var i = 0; i < bankElm.length; i++) {
                    bankElm[i].classList.remove('is-selected');
                }
                event.currentTarget.classList.remove('is-selected');
                bank = event.currentTarget.getAttribute('bank');
            });
        }
    },
    gotoDigitalPayment: function () {
        location.href = '/Payment/digitalPayment';
    },

    gotoOnlinePayment: function () {
        location.href = '/Payment/onlinePayment';
    },

    gotoOfflinePayment: function () {
        location.href = '/Payment/offlinePayment';
    },

    gotoAgentPayment: function () {
        location.href = '/Payment/agentPayment';
    },

    gotoCartPayment: function () {
        location.href = '/Payment/cartPayment';
    },

}
