var Feature = {

    notifyOutOfStock: document.querySelector(".js-add-to-notify-button"),
    submitNotifyOutOfStock: document.querySelector(".js-submit-notify-button"),

    init: function () {
        if (Feature.notifyOutOfStock) {
            Feature.notifyOutOfStock.addEventListener("click", (event) => {
                event.preventDefault();
                let id = event.currentTarget.getAttribute("data-id")
                Feature.checkUserLoginAjax(id)
            });
        }
        if (Feature.submitNotifyOutOfStock) {
            Feature.submitNotifyOutOfStock.addEventListener("click", (event) => {
                event.preventDefault();
                let id = event.currentTarget.getAttribute("data-id")
                Feature.notifyOutOfStockAjax(id)
            });
        }
    },
    checkUserLoginAjax: function (id) {

        function done(event) {
            const data = JSON.parse(event);
            document.querySelector('.js-notify-stock-email').innerHTML = (data.email);
            document.querySelector('.js-notify-stock-mobile').innerHTML = (data.mobile);
            //var modalCloseBtn =  document.querySelector('.js-add-to-notify-button');
            //Utility.triggerEvent(modalCloseBtn,'click');
        };

        function fail(event) {
            if (event.status == 401) {
                Utility.notify('ابتدا باید وارد سامانه شوید', 'danger');
                document.querySelector('#loginModal').modal('show');
                return;
            } else {
                Utility.notify('خطا در برقراری ارتباط با سرور. لطفا دوباره تلاش نمائید', 'danger');
            }
        };

        Utility.sendAjax(null, '/User/checkUserLogin', done, fail);
    },

    notifyOutOfStockAjax: function (id) {
        const mobile = document.querySelector('#outOfStockNotifyModal #mobilecheckBox').checked;
        const email = document.querySelector('#outOfStockNotifyModal #emailcheckBox').checked;
        const notification = document.querySelector('#outOfStockNotifyModal #notificationcheckBox').checked;


        function done(event) {
            var modalCloseBtn =  document.querySelector('#outOfStockNotifyModal .js-modal-outofstock-close');
            Utility.triggerEvent(modalCloseBtn,'click');
            Utility.notify('درخواست شما با موفقیت ثبت شد.', 'danger');
        };

        function fail(event) {
            if (event.status == 401) {
                Utility.notify('ابتدا باید وارد سامانه شوید', 'danger');
                document.querySelector('#loginModal').modal('show');
                return;
            } else {
                Utility.notify('خطا در برقراری ارتباط با سرور. لطفا دوباره تلاش نمائید', 'danger');
            }

        };

        Utility.sendAjax({
            id: id,
            mobile: mobile,
            email: email,
            notification: notification
        }, '/Product/addOutStockProduct', done, fail);

    }
}
