<div class="cart-item">
    <div class="row  align-items-center no-gutters">
        @if(!@$disable)
        <div class="col-sm-1 col-md-1 deleteCol">
            <button type="submit" class="cart-options remove-from-cart" data-id="{{$item->rowId}}">
               <img src="/eqlid/close.svg" alt="">
            </button>
        </div>
        @endif
        <div class="col-5 col-sm-5 col-md-2 picCol">
            <img src="{{ imageUrl('product',$item->id,115,150) }}" alt="{{ $item->title }}">
        </div>
        <div class="col-7 col-sm-6 col-md-9 d-flex align-items-center flex-column flex-md-row no-gutters ">
            <div class="col-md-7 detailCol text-md-left">
                {{ $item->name }}
                @if($item->options && $item->options->count() > 0)
                    @foreach($item->options as $key=>$value)
                        <p class="d-none d-lg-block"> @t($key) : {{$value}} </p>
                    @endforeach
                @endif
            </div>
            <div class="col-md-2 quantityCol">
                @if(@$disable)
                    {{ FarsiLib::convertDigit($item->qty) }} عدد
                @else

                <span> @t('count') </span>
                <!-- <input type="number" data-id="{{$item->rowId}}" data-productQuantity="{{ $item->qty }}" class="cart-qty-select input-text-quantity" value="{{$item->qty}}" min="1" max="{{$item->warehouseQty}}"> -->
                <select data-id="{{$item->rowId}}" data-productQuantity="{{ $item->qty }}" class="cart-qty-select">
                        @for ($i = 1; $i < min((int)$item->warehouseQty , 12 )+ 1 ; $i++)
                            <option  value="{{$i}}" {{ $item->qty == $i ? 'selected' : '' }}>{{ $i }}</option>
                        @endfor
                </select>
                @endif
            </div>
            <div class="col-md-3 priceCol">
                @if($item->discount)
                    <div class="price price-del">{{FarsiLib::convertDigit($item->subtotal) }}تومان</div>
                    <div class="price price-discount">تخفیف  {{ FarsiLib::convertDigit($item->discountTotal()) }} تومان</div>
                    <div class="price price-total">{{ FarsiLib::convertDigit($item->total()) }}تومان</div>
                @else
                    <div class="price price-total">{{ FarsiLib::convertDigit($item->total()) }}تومان</div>
                @endif
            </div>
        </div>
    </div>
</div>