var Cart = {
    addToCartElm: document.querySelectorAll(".add-to-cart"),
    addContinueToCartElm: document.querySelector(".add-continue-to-cart"),
    removeFromCartElm: document.querySelectorAll(".remove-from-cart"),
    qtySelectElm: document.querySelectorAll(".cart-qty-select"),
    basketElm: document.querySelector(".basket"),
    removeAllCartElm: document.querySelector(".remove-all-cart"),
    items: {},
    summaryPriceCopounElm: document.querySelector('.cart-summary .summary-price-copoun-discount'),
    copounBtnElm: document.querySelector('.copounSubmit'),
    removeCopounBtnElm: document.querySelector('.js-remove-copoun'),
    qtyPrevDate: 0,
    approveBtn: document.querySelector(".cart-wrapper .approveBtn"),

    init: function () {
        if (Cart.approveBtn) {
            Cart.approveBtn.addEventListener("click", function () {
                location.href = '/Shipping';
            });
        }

        if (Cart.removeFromCartElm) {
            for (var i = 0; i < Cart.removeFromCartElm.length; i++) {

                Cart.removeFromCartElm[i].addEventListener("click", (event) => {

                    event.preventDefault();
                    var r = confirm("آیا از حذف این کالا اطمینان دارید ؟ ");
                    if (r != true)
                        return false;

                    let id = event.currentTarget.getAttribute('data-id');
                    Cart.removeFromCartAjax(event.currentTarget, id);
                });
            }
        }

        if (Cart.addToCartElm) {
            for (var i = 0; i < Cart.addToCartElm.length; i++) {
                Cart.addToCartElm[i].addEventListener("click", (event) => {
                    event.preventDefault();
                    let id = event.currentTarget.getAttribute("data-id");
                    Cart.addToCartAjax(id)
                })
            }
        }
        if (Cart.addContinueToCartElm) {
            Cart.addContinueToCartElm.addEventListener("click", (event) => {
                event.preventDefault();
                let id = event.currentTarget.getAttribute("data-id")
                Cart.addToCartAjax(id, true)
            })
        }
        if (Cart.qtySelectElm) {
            for (var i = 0; i < Cart.qtySelectElm.length; i++) {
                Cart.qtySelectElm[i].addEventListener('focus', (event) => {
                    qtyPrevDate = event.currentTarget.value;
                });
                Cart.qtySelectElm[i].addEventListener("change", (event) => {
                    event.preventDefault();
                    let qty = event.currentTarget.value,
                        id = event.currentTarget.getAttribute("data-id");

                    if (qty === undefined || qty === null || qty < 1)
                        return Cart.removeFromCartAjax(id), !1;

                    Cart.updateCartAjax(event.currentTarget, id, qty);
                });
            }
        }
        if (Cart.copounBtnElm) {
            Cart.copounBtnElm.addEventListener("click", (event) => {
                event.preventDefault();
                let code = event.currentTarget.parentNode.querySelectorAll('#copounText').value;
                if (code === undefined || code === null)
                    return false;
                const loadingText = `
            در حال پردازش...
                <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>`;

                event.currentTarget.setAttribute('data-original-text', event.currentTarget.innerHTML);
                event.currentTarget.innerHTML = loadingText;
                event.currentTarget.setAttribute("disabled", "disabled");
                Cart.addCopounAjax(code, event.currentTarget)
            })
        }
        if (Cart.removeCopounBtnElm) {
            Cart.removeCopounBtnElm.addEventListener("click", (event) => {
                event.preventDefault();
                Cart.removeCopounAjax(event.currentTarget)
            })
        }

    },
    // add to cart
    addToCartAjax: function (id, goToBasket = false) {
        function done(event) {
            Cart.items[id] = 1;
            Utility.dispatchEvent('cart.add', JSON.parse(event));
            if (goToBasket)
                location.href = '/Cart';
        };

        function fail(event) {
            Utility.notify('موجود کالا در انبار کمتر از این مقدار است', 'danger');
        };

        Utility.sendAjax({
            id: id,
            type: 'product'
        }, '/Cart/store', done, fail);
    },


    updateCartAjax: function (element, id, qty) {
        let status = false;

        function done(event) {
            Cart.items[id] = qty;
            Utility.dispatchEvent('cart.update', JSON.parse(event), element);
            status = true;
        };

        function fail(event) {
            Utility.notify(JSON.parse(event).msg, 'danger');
            status = false;
        };

        Utility.sendAjax({
            id: id,
            qty: qty,
            type: 'product'
        }, '/Cart/update', done, fail);
        return status;
    },


    removeFromCartAjax: function (element, id) {

        function done(event) {
            delete Cart.items[id];
            let parent = element.closest('.cart-item');
            parent.remove();
            Utility.dispatchEvent('cart.remove', JSON.parse(event));
        };

        function fail(event) {
            Utility.notify('خطا  در برقراری ارتباط', 'danger');
        };

        Utility.sendAjax({
            id: id
        }, '/Cart/remove', done, fail);
    },

    removeAllCartItemsAjax: function (element) {
        function done(event) {
            Cart.items = {};
            let parent = element.closest('.cart-list');
            parent.remove();
            Utility.dispatchEvent('cart.removeAll', JSON.parse(event));
        };

        function fail(event) {
            Utility.notify('خطا  در برقراری ارتباط', 'danger');
        };

        Utility.sendAjax({}, '/Cart/removeAll', done, fail);
    },

    addCopounAjax: function (code, element) {

        function done(event) {

            element.innerHTML = element.getAttribute('data-original-text');
            element.removeAttribute("disabled");
            const resultAjax = JSON.parse(event);

            if (resultAjax.discountDetail.accepted == 'copoun') {
                Utility.dispatchEvent('cart.copoun.add', resultAjax);
                document.querySelector('#ship-copoun-submited .alert').classList.add('d-none');
            } else {
                Utility.notify('کد تخفیف ثبت  شده در جشنواره قابل استفاده نمی باشد.', 'danger');
            }
            $('#ship-copoun-submited').classList.remove('d-none');
            $('#ship-copoun-unsubmited').classList.add('d-none');

        };

        function fail(event) {
            summaryPriceCopounElm.parentNode.classList.add('d-none');
            element.innerHTML = element.getAttribute('data-original-text');
            element.removeAttribute("disabled");
            Utility.notify('کد تخفیف وارد شده اعتبار  ندارد', 'danger');
        };

        Utility.sendAjax({
            copounCode: code
        }, '/Cart/addCopoun', done, fail);
    },
    removeCopounAjax: function (element) {
        function done(event) {
            const resultAjax = JSON.parse(event);
            Utility.dispatchEvent('cart.copoun.remove', resultAjax);
            $('#ship-copoun-submited').classList.add('d-none');
            $('#ship-copoun-unsubmited').classList.remove('d-none');
        };

        function fail(event) {
            notify('خطا در برقراری ارتباط', 'danger');
        };

        Utility.sendAjax({}, '/Cart/removeCopoun', done, fail);
    }
}
