@section('content')
<section>
    <div class="container cart-wrapper">
        @if (session()->has('success_message'))
            <div class="alert alert-success">
                {{ session()->get('success_message') }}
            </div>
        @endif

        @if(count($errors) > 0)
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        @if((int)Cart::count() > 0)
            @include('cart::index.cartSteps',['cart' => 'is-active','ship'=>'','payment'=>''])
            <div class="row">
                <div class="col-12 col-md-8">
                    <h4 class="cart-list-title">سبد خرید</h4>
                    @if (Cart::count() > 0)
                    <div class="cart-list cart-list-box">
                        @foreach (Cart::content() as $item)
                            @include('cart::index.cartItem',['item' => $item])
                        @endforeach
                    </div>
                    @endif
                </div>
                <div class="col-12 col-md-4">
                    @include('cart::index.cartSummary',['btnTitle' => 'ادامه ثبت سفارش'])
                </div>
            </div>
        @else
            <div class="row">
                <div class="col-12">
                    <div class="cart-list cart-list-box empty-cart">
                        <div class="cart-item">
                            <div class="d-flex align-items-center no-gutters flex-column justify-content-center">
                                <div class="pt-5 pb-3"><i class="icon-basket"></i></div>
                                <div class="">سبد خرید شما خالی است</div>
                            </div>
                        </div>                                    
                    </div>
                </div>
            </div>
        @endif
    </div>
</section>

@endsection

@section('extra-js')
    <script type="text/javascript">
        document.getElementsByClassName("approveBtn")[0].addEventListener("click", function(){
            location.href = '/Shipping';
        });
    </script>
@endsection
