import Toastify from 'toastify-js'
import $ from 'jquery'
import {DigitHelper} from '../../../../../../js/helper/digitHelper'
import {IsValidNationalCode} from '../../../../../../js/helper/helper'

export class Ship {
    constructor() {
        this.addressRadio = ".addresRadio";
        this.currentShipElm = $(".current-ship");
        this.changeLocationElm = $('.btn-change-location');
        this.createLocationElm = $('.js-add-address-btn');
        this.radioTemplate = $('.js-radio-div');
        
        this.currentTitle = '.js-ship-title';
        this.currentName = '.js-ship-name';
        this.currentMobile = '.js-ship-mobile';
        this.currentPostalCode = '.js-ship-postalcode';
        this.currentAddress = '.js-ship-address';

        this.shipModalElm = $('#changeAddressModal');
        this.modalTitleElm = $('#f-titleAddress');
        this.modalMobileElm = $('#f-mobileAddress');
        this.modalAddressElm = $('#f-valueAddress');
        this.modalNameElm = $('#f-name');//
        this.modalProvinceElm = $('#provinceListCombo');
        this.modalCityElm = $('#cityListCombo');
        this.modalRegionElm = $('#regionListCombo');
        this.modalParishElm = $('#parishListCombo');
        this.modalPostalCodeElm = $('#f-postalCode');//
        this.modalTitle = $('#f-modal-title');
        this.modalIdElm = $('#f-idAddress');
        this.modalSubmitElm = $('#f-submitAddress');
        
        this.postCheckBox = "input[name='bikePostName']";
        

        this.summaryPriceSubtotalElm = $('.cart-summary .summary-price-subtotal');
        this.summaryPriceDiscountElm = $('.cart-summary .summary-price-discount');
        this.summaryPricePostElm = $('.cart-summary .summary-price-post');
        this.summaryPriceTotalElm = $('.cart-summary .cart-summary-price-value');
        this.summaryPriceCopounElm = $('.cart-summary .summary-price-copoun-discount');

        this.approveBtn = $(".shipping-wrapper .approveBtn");
        this.priceTag = ' تومان ';

    }

    binding() {
       

        $(document).on("change",this.addressRadio ,(event) => {
            this.radioChanged(event)
        });

        $(document).on("change",this.postCheckBox ,(event) => {
            this.postCheckboxChanged(event)
        });

        if($('input[name=customRadio]:checked').length){
            const address = JSON.parse($('input[name=customRadio]:checked').attr('data-address'))
            if(address.city != 1){
                $("#bike-post").attr('disabled', true);
                $("#normal-post").attr('disabled', false);
                $("#bike-post").prop("checked", false);
                $("#normal-post").prop("checked", true);
                this.postCheckboxChanged();
            }
            else{
                $("#normal-post").attr('disabled', true);
                $("#bike-post").attr('disabled', false);
                $("#normal-post").prop("checked", false);
                $("#bike-post").prop("checked", true);
                this.postCheckboxChanged();
            }
        }

        this.shipModalElm.on('show.bs.modal', (event) => {
            const button = $(event.relatedTarget) 
            const modal = $(event.currentTarget)
            
            if (button[0] === this.changeLocationElm[0]){
                const address = JSON.parse($('input[name=customRadio]:checked').attr('data-address'))
                
                modal.find(this.modalTitle).text('تغییر اطلاعات آدرس')
                modal.find(this.modalTitleElm).val(address.title)
                modal.find(this.modalMobileElm).val(address.mobile)
                modal.find(this.modalAddressElm).val(address.address)
                
                modal.find(this.modalNameElm).val(address.name)
                
                modal.find(this.modalProvinceElm).find('option[value="'+ address.province +'"]').prop('selected',true).trigger('change')
                modal.find(this.modalCityElm).find('option[value="'+ address.city +'"]').prop('selected',true).trigger('change')
                modal.find(this.modalRegionElm).find('option[value="'+ address.region +'"]').prop('selected',true).trigger('change');
                modal.find(this.modalParishElm).find('option[value="'+ address.parish +'"]').prop('selected',true);

                modal.find(this.modalPostalCodeElm).val(address.postalCode)

                const id = $('input[name=customRadio]:checked').data('id')
                modal.find(this.modalIdElm).val(id)
            }
            else if (button[0] === this.createLocationElm[0]){
                modal.find(this.modalTitle).text('ایجاد آدرس جدید')
                modal.find(this.modalTitleElm).val('')
                modal.find(this.modalMobileElm).val('')
                modal.find(this.modalAddressElm).val('')
                modal.find(this.modalNameElm).val('')
                modal.find(this.modalProvinceElm).val('')
                modal.find(this.modalCityElm).val('')
                modal.find(this.modalRegionElm).val('')
                modal.find(this.modalParishElm).val('')
                modal.find(this.modalPostalCodeElm).val('')
                modal.find(this.modalIdElm).val(0)
            }
          
        });

        this.modalSubmitElm.on("click" , (event) => {
            event.preventDefault();
            const title = $.trim(this.modalTitleElm.val())
            const mobile = $.trim(this.modalMobileElm.val())
            const address = $.trim(this.modalAddressElm.val())
            const name = $.trim(this.modalNameElm.val())
            const province = this.modalProvinceElm.val()
            const city = this.modalCityElm.val()
            const region = this.modalRegionElm.val()
            const parish = this.modalParishElm.val()
            const postalCode = $.trim(this.modalPostalCodeElm.val())

            if (title == '' || title.length == 0){
                this.notify('عنوان آدرس باید وارد شود','danger');
                return false;
            }
            if (mobile == '' || mobile.length != 11 || !$.isNumeric(mobile)){
                this.notify('شماره تماس 11 رقمی باید وارد شود','danger');
                return false;
            }
            if (address == '' || address.length == 0){
                this.notify('آدرس به درستی وارد نشده است','danger');
                return false;
            }
            if (name == '' || name.length == 0){
                this.notify('ثبت اطلاعات نام گیرنده الزامی می باشد.','danger');
                return false;
            }
            if (province == '' || province.length == 0){
                this.notify('استان به درستی وارد نشده است','danger');
                return false;
            }
            if (city == null || city == '' || city.length == 0){
                this.notify('شهر به درستی وارد نشده است','danger');
                return false;
            }
            
            if (region == null || region == '' || region.length == 0){
                this.notify('منطقه به درستی وارد نشده است','danger');
                return false;
            }
            if (parish == null || parish == '' || parish.length == 0){
                this.notify('محله به درستی وارد نشده است','danger');
                return false;
            }
            if (postalCode == '' || postalCode.length != 10 || !$.isNumeric(postalCode)){
                this.notify('کد پستی به درستی وارد نشده است','danger');
                return false;
            }

            this.sendUpdateAddressAjax();
            this.shipModalElm.modal('hide');
        });

        this.approveBtn.on("click" , (event) => {
            event.preventDefault();
            // const payment =  $('input[name=paymentRadio]:checked').val()
            const address = $('input[name=customRadio]:checked').data('id')
            const post =  $('input[name=bikePostName]:checked').val()

            if (!address){
                this.notify('آدرس ارسالی به درستی مشخص نشده است.');
                return false;
            }

            // if (!payment){
            //     this.notify('نحوه پرداخت به درستی مشخص نشده است.');
            //     return false;
            // }

            // if (payment == 'onlinePayment' && !this.bank){
            //     this.notify('نوع بانک انتخاب نشده است');
            //     return false;
            // }

            if (!post){
                this.notify('نحوه ارسال مشخص نشده است');
                return false;
            }

            let name,family,intcode;
            
            if($('input[name=userInfo-name]').length){
                name = $('input[name=userInfo-name]').val()
                if(!name){
                    this.notify('در قسمت مشخصات شما، نام وارد نشده است');
                    return false;
                }
            }
            if($('input[name=userInfo-family]').length){
                family = $('input[name=userInfo-family]').val()
                if(!family){
                    this.notify('در قسمت مشخصات شما، نام خانوادگی وارد نشده است');
                    return false;
                }
            }
            if($('input[name=userInfo-intcode]').length){
                intcode = $('input[name=userInfo-intcode]').val()
                if(!intcode){
                    this.notify('در قسمت مشخصات شما، کد ملی وارد نشده است');
                    return false;
                }
                const isValidNC = IsValidNationalCode(intcode);
                if(!isValidNC){
                    this.notify('در قسمت مشخصات شما، کد ملی صحیح نیست');
                    return false;
                }
            }
            
            $('#h-address').val(address);
            // $('#h-payment').val(payment);
            $('#h-post').val(post);
            $('#h-bank').val(this.bank);
            $('#h-userInfo').val(name ? JSON.stringify({
                name: name,
                family: family,
                intcode: intcode
            }) : null);
            
            $('#shippingForm').attr('action', "/Payment").submit();
            
        });
    }

    radioChanged(event){
        event.preventDefault();
        if ($(event.currentTarget).is(':checked')){
            const address = JSON.parse($(event.currentTarget).attr('data-address'))
            this.changePostMethodAuto(address.city != 1,event);
            
            let id = $(event.currentTarget).data("id");
            this.changeAddressAjax($(event.currentTarget),id)
        }
    }

    changePostMethodAuto(isNormalPost,event){
        if(isNormalPost){
            $("#bike-post").attr('disabled', true);
            $("#normal-post").attr('disabled', false);
            $("#bike-post").prop("checked", false);
            $("#normal-post").prop("checked", true);
        }
        else{
            $("#normal-post").attr('disabled', true);
            $("#bike-post").attr('disabled', false);
            $("#normal-post").prop("checked", false);
            $("#bike-post").prop("checked", true);
        } 
        this.postCheckboxChanged(event);
    }

    postCheckboxChanged(event){
        if(event)
            event.preventDefault();
        
        const isBikePost = $("input[name='bikePostName']:checked").val();
        const address = JSON.parse($('input[name=customRadio]:checked').attr('data-address'))
        if(isBikePost == 'bikePost'){
            if(parseInt(address.city) == 1)
                this.changePostMethod(isBikePost)
            else{
                this.notify('ارسال بوسیله پیک فقط در شهر تهران قابل انتخاب است','danger'); 
            }
        }else{
            if(parseInt(address.city) != 1)
                this.changePostMethod(isBikePost)
            else{
                this.notify('ارسال بوسیله پست پیشتاز فقط در شهرستان ها قابل انتخاب است','danger'); 
            }
                
        }    
    }

    sendUpdateAddressAjax(){
        const data = {
            id :            this.modalIdElm.val(),
            title :         this.modalTitleElm.val(),
            mobile :        this.modalMobileElm.val(),
            address :       this.modalAddressElm.val(),
            name :          this.modalNameElm.val(),
            province :      this.modalProvinceElm.val(),
            city :          this.modalCityElm.val(),
            region :        this.modalRegionElm.val(),
            parish :        this.modalParishElm.val(),
            postalCode :    this.modalPostalCodeElm.val()
        }
        let result = this.sendAjax({data:data},'/Shipping/update');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");

            if (data.id == '0'){
                let newObj = this.radioTemplate.first().clone();
                if (newObj.length == 0)
                    location.reload();
                newObj.find('input').attr('id','customRadio' + JSON.parse(event).id)
                newObj.find('input').attr('data-id', JSON.parse(event).id)
                newObj.find('input').attr('data-address', event)
                newObj.find('label').attr('for','customRadio' + JSON.parse(event).id)
                newObj.find('label').text(data.title)
                let parent = this.radioTemplate.parent()
                parent.prepend(newObj);
            }else{
                $('input[name=customRadio]:checked').parent().find('label').text(JSON.parse(event).title);
                $('input[name=customRadio]:checked').attr('data-address', event)
            }
            this.dispatchEvent('ship.update',JSON.parse(event));
            $(this.addressRadio).trigger('change');
        });

        result.fail((event) => {
            this.notify(JSON.parse(event.responseText).msg,'danger');
        });
    }

    changePostMethod(isBikePost){
        let result = this.sendAjax({postMethod:isBikePost},'/Shipping/changePostMethod');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            this.dispatchEvent('ship.post.change',JSON.parse(event));
        });

        result.fail((event) => {
            this.notify('خطا  در برقراری ارتباط','danger');
        });
    }

    changeAddressAjax(element,id){
        let result = this.sendAjax({id:id},'/Shipping/change');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            this.dispatchEvent('ship.change',JSON.parse(event));
        });

        result.fail((event) => {
            this.notify('خطا  در برقراری ارتباط','danger');
        });
    }

    dispatchEvent(event,data,element = null){
        switch(event){
            case 'ship.change':{
                this.notify('آدرس دریافت تغییر کرد');
                this.updateCurrentLocation(data);
                break;
            }

            case 'ship.update':{
                this.notify('آدرس با موفقیت تغییر پیدا کرد');
                this.updateCurrentLocation(data);
                break;
            }

            case 'ship.post.change':{
                this.notify('نحوه ارسال مرسوله تغییر یافت');
                this.updateSummaryPrice(data);
                break;
            }

            
        }
    }

    updateCurrentLocation(data){
        this.currentShipElm.find(this.currentName).html(data.name);
        this.currentShipElm.find(this.currentMobile).html(DigitHelper.convertDigit(data.mobile,'fa'));
        this.currentShipElm.find(this.currentPostalCode).html(DigitHelper.convertDigit(data.postalCode,'fa'));
        this.currentShipElm.find(this.currentAddress).html(data.address);
    }

    updateSummaryPrice(data){
        this.summaryPriceSubtotalElm.html(DigitHelper.writeNumber(data.subtotal)+this.priceTag);
        this.summaryPriceDiscountElm.html(DigitHelper.writeNumber(data.discount)+this.priceTag);
        let text = 'ارسال رایگان';
        if (data.post > 0 ) 
            text = DigitHelper.writeNumber(data.post) + this.priceTag ;
        if (data.postMethod == 'unknown')
            text = 'نامشخص'
        else if(data.postStatus == 2 || data.postStatus == 3)
            text = 'پس کرایه'
        
        this.summaryPricePostElm.html(text);
        
        this.summaryPriceCopounElm.html(DigitHelper.writeNumber(data.copounDiscount)+this.priceTag);
        this.summaryPriceTotalElm.html(DigitHelper.writeNumber(data.total)+this.priceTag);
    }

    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 2000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
         
        }).showToast();
    }

    sendAjax(data,url){
        const res = $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    dataType: "html",
                    data: data
                });
        return res;
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }
}
