import Toastify from 'toastify-js'
import $ from 'jquery'
import {DigitHelper} from '../../../../../../js/helper/digitHelper'

export class Payment {
    constructor() {
        this.approveBtn = $(".preview-wrapper .approveBtn");
        this.bankElm = ".payment-bank-item";
        this.bank = "";
    }

    binding() {
        this.approveBtn.on("click" , (event) => {
            event.preventDefault();
            const payment =  $('input[name=paymentRadio]:checked').val()
            //const payment =  $('input[name=paymentMethod]').val()

            if (!payment){
                this.notify(' شیوه پرداخت به درستی مشخص نشده است.');
                return false;
            }

            let url = "";
            if (payment == 'onlinePayment')
                url =  '/Payment/onlinePayment';
            else if (payment == 'offlinePayment')
                url =  '/Payment/offlinePayment';
            else if (payment == 'agentPayment')
                url =  '/Payment/agentPayment';
            else if (payment == 'cartPayment')
                url =  '/Payment/cartPayment';
            else if (payment == 'digitalPayment')
                url =  '/Payment/digitalPayment';
            else 
                url =  '/Payment/onlinePayment';


            $('#h-bank').val(this.bank ? this.bank : 'mellat');
            $('#paymentForm').attr('action', url).submit();

        });

        $(document).on("click",this.bankElm ,(event) => {
            event.preventDefault();
            $(this.bankElm).each(function(){
                $(this).removeClass('is-selected');
            });
            $(event.currentTarget).addClass('is-selected');
            this.bank = $(event.currentTarget).data('bank');
        });


    }

    gotoDigitalPayment(){
        location.href = '/Payment/digitalPayment';
    }

    gotoOnlinePayment(){
        location.href = '/Payment/onlinePayment';
    }

    gotoOfflinePayment(){
        location.href = '/Payment/offlinePayment';
    }

    gotoAgentPayment(){
        location.href = '/Payment/agentPayment';
    }

    gotoCartPayment(){
        location.href = '/Payment/cartPayment';
    }

    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 2000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
          
        }).showToast();
    }

}
