import Toastify from 'toastify-js'
import $ from 'jquery'
import {DigitHelper} from '../../../../../../js/helper/digitHelper'

export class Feature {
    constructor() {
        this.notifyOutOfStock = ".js-add-to-notify-button";
        this.submitNotifyOutOfStock = ".js-submit-notify-button";
    }

    binding() {
        $(document).on("click",this.notifyOutOfStock ,(event) => {
            event.preventDefault();
            let id = $(event.currentTarget).data("id")
            this.checkUserLoginAjax(id) 
        });

        $(document).on("click",this.submitNotifyOutOfStock ,(event) => {
            event.preventDefault();
            let id = $(event.currentTarget).data("id")
            this.notifyOutOfStockAjax(id) 
        });
    }

    checkUserLoginAjax(id){
        let result = this.sendAjax(null,'/User/checkUserLogin');
        result.done((event) =>{
            const data = JSON.parse(event);
            $('.js-notify-stock-email').text(data.email);
            $('.js-notify-stock-mobile').text(data.mobile);
            $('#outOfStockNotifyModal').modal('show');
        });
        result.fail((event) => {
            if(event.status == 401){
                this.notify('ابتدا باید وارد سامانه شوید','danger');
                $('#loginModal').modal('show');
                return;
            }else{
                this.notify('خطا در برقراری ارتباط با سرور. لطفا دوباره تلاش نمائید','danger');
            }
        });
    }

    notifyOutOfStockAjax(id){
        const mobile = $('#outOfStockNotifyModal #mobilecheckBox').prop('checked');
        const email = $('#outOfStockNotifyModal #emailcheckBox').prop('checked');
        const notification = $('#outOfStockNotifyModal #notificationcheckBox').prop('checked');

        let result = this.sendAjax({id:id,mobile:mobile,email:email,notification:notification},'/Product/addOutStockProduct');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            $('#outOfStockNotifyModal').modal('hide');
            this.notify('درخواست شما با موفقیت ثبت شد.','danger');
        });

        result.fail((event) => {
            if(event.status == 401){
                this.notify('ابتدا باید وارد سامانه شوید','danger');
                $('#loginModal').modal('show');
                return;
            }else{
                this.notify('خطا در برقراری ارتباط با سرور. لطفا دوباره تلاش نمائید','danger');
            }
            
        });
    }


    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 2000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
         
        }).showToast();
    }

    sendAjax(data,url){
        const res = $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    dataType: "html",
                    data: data
                });
        return res;
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }
}
