import Toastify from 'toastify-js'
import $ from 'jquery'
import {DigitHelper} from '../../../../../../js/helper/digitHelper'

export class Cart {
    constructor() {
        this.addToCartElm = $(".add-to-cart")
        this.addContinueToCartElm = $(".add-continue-to-cart")
        this.removeFromCartElm = $(".remove-from-cart")
        this.qtySelectElm = $(".cart-qty-select")
        this.basketElm = $(".basket")
        this.removeAllCartElm = $(".remove-all-cart")
        this.basketCounterElm = $(".basket .badge")
        this.items = {}

        this.itemOrginalPriceElm = $('.cart-item .priceCol .price-del');
        this.itemDiscountPriceElm = $('.cart-item .priceCol .price-discount');
        this.itemTotalPriceElm = $('.cart-item .priceCol .price-total');

        this.summaryPriceSubtotalElm = $('.cart-summary .summary-price-subtotal');
        this.summaryPriceDiscountElm = $('.cart-summary .summary-price-discount');
        this.summaryPricePostElm = $('.cart-summary .summary-price-post');
        this.summaryPriceTotalElm = $('.cart-summary .cart-summary-price-value');
        this.summaryPriceCopounElm = $('.cart-summary .summary-price-copoun-discount');
        this.summaryPriceDiscountTitleElm = $('.cart-summary .summary-price-discount-title');

        this.copounBtnElm = $('.copounSubmit');
        this.removeCopounBtnElm = $('.js-remove-copoun');
        this.qtyPrevDate = 0;

        this.priceTag = ' تومان ';
    }

    binding() {
        this.gotoShipping();
        
        this.removeFromCartElm.on("click", (event) => {
            event.preventDefault();
            var r = confirm("آیا از حذف این کالا اطمینان دارید ؟ ");
            if (r != true)
                return false;
                    
            let id = $(event.currentTarget).data("id");
            this.removeFromCartAjax($(event.currentTarget),id)
        });

        this.addToCartElm.on("click", (event) => {
            event.preventDefault();
            let id = $(event.currentTarget).data("id")
                //qty = parseFloat($(this).data("qty"))
                
                // if (qty === undefined || qty === null || qty < 1) 
                //     return this.removeFromCartAjax(id), !1;

            this.addToCartAjax(id)           
        })

        this.addContinueToCartElm.on("click", (event) => {
            event.preventDefault();
            let id = $(event.currentTarget).data("id")
            this.addToCartAjax(id,true)           
        })

        this.qtySelectElm.on('focus',(event) => {
            this.qtyPrevDate = $(event.currentTarget).value;
        }).on("change", (event) => {
            event.preventDefault();
            let qty = $(event.currentTarget).val(),
                id = $(event.currentTarget).data("id");

            if (qty === undefined || qty === null || qty < 1) 
                    return this.removeFromCartAjax(id), !1;
                
            this.updateCartAjax($(event.currentTarget),id,qty);

        });

        this.copounBtnElm.on("click", (event) => {
            event.preventDefault();
            let code = $(event.currentTarget).parent().find('#copounText').val();
                
            if (code === undefined || code === null) 
                return false;
            const loadingText = `
            در حال پردازش...
                <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>`;
            $(event.currentTarget).data('original-text', $(event.currentTarget).html());
            $(event.currentTarget).html(loadingText);
            $(event.currentTarget).attr("disabled", "disabled");
            this.addCopounAjax(code, $(event.currentTarget))           
        })

        this.removeCopounBtnElm.on("click", (event) => {
            event.preventDefault();
            this.removeCopounAjax($(event.currentTarget))           
        })
    }

    gotoShipping(){
        $(".cart-wrapper .approveBtn").on("click", function(){
            location.href = '/Shipping';
        });
    }

    addToCartAjax(id,goToBasket = false){
        let result = this.sendAjax({id:id,type:'product'},'/Cart/store');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            this.items[id] = 1;
            this.dispatchEvent('cart.add',JSON.parse(event));
            if (goToBasket)
                 location.href = '/Cart';
        });

        result.fail((event) => {
            this.notify('موجود کالا در انبار کمتر از این مقدار است','danger');
        });
    }

    updateCartAjax(element,id,qty){
        let result = this.sendAjax({id:id, qty:qty,type:'product'},'/Cart/update');
        let status = false;
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            this.items[id] = qty;
            this.dispatchEvent('cart.update',JSON.parse(event),element);
            status = true;
        });

        result.fail((event) => {
            this.notify(JSON.parse(event.responseText).msg,'danger');
            status = false;
        });
        return status;
    }

    removeFromCartAjax(element,id){
        let result = this.sendAjax({id:id},'/Cart/remove');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            delete this.items[id];
            let parent = element.closest('.cart-item');
            parent.remove();
            this.dispatchEvent('cart.remove',JSON.parse(event));
        });

        result.fail((event) => {
            this.notify('خطا  در برقراری ارتباط','danger');
        });
    }

    removeAllCartItemsAjax(element){
        let result = this.sendAjax('/Cart/removeAll');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            delete this.items
            this.items = {};
            let parent = element.closest('.cart-list');
            parent.remove();
            this.dispatchEvent('cart.removeAll',JSON.parse(event));
        });

        result.fail((event) => {
            this.notify('خطا  در برقراری ارتباط','danger');
        });
    }

    addCopounAjax(code, element){
        let result = this.sendAjax({copounCode:code},'/Cart/addCopoun');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            element.html(element.data('original-text'));
            element.removeAttr("disabled");
            const resultAjax = JSON.parse(event);

            if (resultAjax.discountDetail.accepted == 'copoun'){
                this.dispatchEvent('cart.copoun.add',resultAjax);
                $('#ship-copoun-submited .alert').addClass('d-none');
            }else{
                this.notify('کد تخفیف ثبت  شده در جشنواره قابل استفاده نمی باشد.','danger');    
            }
            $('#ship-copoun-submited').removeClass('d-none');
            $('#ship-copoun-unsubmited').addClass('d-none');
            
        });

        result.fail((event) => {
            this.summaryPriceCopounElm.parent().addClass('d-none');
            element.html(element.data('original-text'));
            element.removeAttr("disabled");
            this.notify('کد تخفیف وارد شده اعتبار  ندارد','danger');
        });
    }

    removeCopounAjax(element){
        let result = this.sendAjax({},'/Cart/removeCopoun');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            const resultAjax = JSON.parse(event);
            this.dispatchEvent('cart.copoun.remove',resultAjax);
            $('#ship-copoun-submited').addClass('d-none');
            $('#ship-copoun-unsubmited').removeClass('d-none');
        });

        result.fail((event) => {
            this.notify('خطا در برقراری ارتباط','danger');
        });
    }

    dispatchEvent(event,data,element = null){
        switch(event){
            case 'cart.add':{
                this.notify('محصول با موفقیت اضافه شد.');
                this.updateBasketLogo(data);
                break;
            }

            case 'cart.update':{
                this.notify('محصول با موفقیت اضافه شد.');
                this.updateBasketLogo(data);
                this.updateItemPrice(data,element);
                this.updateSummaryPrice(data);
                break;
            }

            case 'cart.remove':{
                this.notify('محصول با موفقیت حذف شد');
                this.updateBasketLogo(data);
                this.updateSummaryPrice(data);
                break;
            }

            case 'cart.removeAll':{
                this.notify('سبد شما خالی شد');
                this.updateBasketLogo(data);
                this.updateSummaryPrice(data);
                break;   
            }

            case 'cart.copoun.add':{
                this.notify('کد تخفیف  با موفقیت ثبت شد');
                this.updateSummaryPrice(data);
                break;
            }

            case 'cart.copoun.remove':{
                this.notify('کد تخفیف  با موفقیت  حذف شد');
                this.updateSummaryPrice(data);
                break;
            }
        }
    }

    updateItemPrice(data,element){
        let parent = element.closest('.cart-item');
        parent.find(this.itemOrginalPriceElm).html(DigitHelper.writeNumber(data.itemSubtotal)+this.priceTag);
        parent.find(this.itemDiscountPriceElm).html(DigitHelper.writeNumber(data.itemDiscountTotal)+this.priceTag);
        parent.find(this.itemTotalPriceElm).html(DigitHelper.writeNumber(data.itemTotal)+this.priceTag);
    }

    updateSummaryPrice(data){

        this.summaryPriceSubtotalElm.html(DigitHelper.writeNumber(data.subtotal)+this.priceTag);
        this.summaryPriceDiscountElm.html(DigitHelper.writeNumber(data.discount)+this.priceTag);
        let textDiscount = 'تخفیف';
        if(data.discountDetail.accepted == 'extra')
            textDiscount  = 'تخفیف خرید اینترنتی' ;
        if(data.discountDetail.accepted == 'copoun')
            textDiscount  = 'مبلغ کد تخفیف';
        if(data.discountDetail.accepted == 'festivalDiscount')
            textDiscount  = 'تخفیف جشنواره';
        
        this.summaryPriceDiscountTitleElm.html(textDiscount);
        let text = 'ارسال رایگان';
        if (data.post > 0 ) 
            text = DigitHelper.writeNumber(data.post) + this.priceTag ;

        (data.postMethod != 'unknown') ? this.summaryPricePostElm.html(text) : this.summaryPricePostElm.html('نامشخص');
        
        this.summaryPriceTotalElm.html(DigitHelper.writeNumber(data.total)+this.priceTag);
    }

    updateBasketLogo(data){
        this.basketCounterElm.each(function(key,value){
            $(this).html(DigitHelper.writeNumber(data.count));
        })
    }

    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 2000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
        }).showToast();
    }

    total() {
        let total = 0 
        for(let pdtId in this.items) {
            total += this.catalog.products.find(pdt => {
                return pdt.id == pdtId 
            }).price * this.items[pdtId]
        }   

        return total 
    }

    sendAjax(data,url){
        const res = $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    dataType: "html",
                    data: data
                });
        return res;
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }
}
