@section('content')
<div class="book-page-detail">
<section>
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-3">
                <div class="thumbnail item-box">
                    <a href="#">
                        <img itemprop="image" class="img-responsive" src="{{'/pic/book/' . $book->xbookid . 'w260h370c1/' . str_random() . '.jpg?nocache=1'}}" alt="{{$book->xbook_title}}">
                    </a>
                </div>
            </div>
            <div class="col-12 col-md-9">
                <div class="row align-items-end">
                    <div class="col-12 col-md-8 col-lg-9">
                        <div class="book-detail-info">
                            <div class="d-flex">
                               <div>
                                 <h1>{{$book->xbook_title}}</h1>
                                 <h2>{{$book->xbook_subtitle}}</h2>
                               </div>
                                <div class="social-offer favorite-offer">
                                    <a href="#" class="social-icon social-icon-sm social-icon-transparent social-favorite js-update-favorite-btn @if(Auth::user() && Auth::user()->favorites->contains($book->xbookid)) social-favorite-active @endif" title="اضافه به لیست علاقه مندی" data-id="{{$book->xbookid}}">
                                        <i class="icon-heart"></i>
                                        <i class="icon-heart"></i>
                                    </a>
                                </div>
                            </div>
                            @if(@$book->author->count() > 0)
                            <div class="mb-1">
                                <span class="book-detail-info-name">@t('author'):</span>
                                @foreach(@$book->author()->orderBy('xrank','desc')->get() as $author)
                                <a class="book-detail-info-desc btn-link-spoiler ml-2" href="/Author/detail/{{$author->xauthorid}}/{{$author->xauthor_name}}">
                                        {{$author->xauthor_name}}
                                        @if(!$loop->last)
                                        ،
                                        @endif
                                </a>
                                @endforeach
                            </div>
                            @endif
                            @if($book->translator->count() > 0)
                            <div class="mb-1">
                                <span class="book-detail-info-name">@t('translator'):</span>
                                @foreach(@$book->translator as $author)
                                <a class="book-detail-info-desc btn-link-spoiler ml-2" href="/Author/detail/{{$author->xauthorid}}/{{$author->xauthor_name}}">
                                        {{$author->xauthor_name}}
                                        @if(!$loop->last)
                                        ،
                                        @endif
                                </a>
                                @endforeach
                            </div>
                            @endif
                            @if(@$book->publisher)
                            <div class="mb-1">
                                <span class="book-detail-info-name">@t('publisher'):</span>
                                <a class="book-detail-info-desc btn-link-spoiler ml-2" href="#">
<!-- href="/Publisher/detail/{{$book->xpublisherid}}/{{$book->publisher->xpublisher_name}}" -->
                                    {{$book->publisher->xpublisher_name}} </a>
                            </div>
                            @endif
                            <div class="social-offer">
                                <a  class="social-icon social-icon-sm social-icon-transparent social-facebook" uib-tooltip="@t(Share on Facebook)" title="@t(Share on Facebook)" rel="nofollow" href="http://www.facebook.com/sharer.php?u={{url()->current()}}&amp;t='{{$book->xbook_title}}'" onclick="window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=700,height=450');return false">
                                    <i class="icon-facebook"></i>
                                    <i class="icon-facebook"></i>
                                </a>
                                <a class="social-icon social-icon-sm social-icon-transparent social-twitter" uib-tooltip="@t(Tweet on Twitter)" title="@t(Tweet on Twitter)" rel="nofollow" href="http://twitter.com/intent/tweet/?text={{$book->xbook_title}}&amp;url={{url()->current()}}" onclick="window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=700,height=450');return false">
                                    <i class="icon-twitter"></i>
                                    <i class="icon-twitter"></i>
                                </a>
                                <a class="social-icon social-icon-sm social-icon-transparent social-gplus" uib-tooltip="@t(Share on Google Plus)" title="@t(Share on Google Plus)" rel="nofollow" href="https://plus.google.com/share?url={{url()->current()}}" onclick="window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=700,height=450');return false">
                                    <i class="icon-gplus"></i>
                                    <i class="icon-gplus"></i>
                                </a>
                                <a class="social-icon social-icon-sm social-icon-transparent social-telegram" uib-tooltip="@t(Send to Telegram)" title="@t(Send to Telegram)" rel="nofollow" href="https://telegram.me/share/url?url={{url()->current()}}&amp;text={{$book->xbook_title}}" onclick="window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=700,height=450');return false">
                                    <i class="icon-telegram"></i>
                                    <i class="icon-telegram"></i>
                                </a>
                            </div>

                        </div>
                    </div>
                    <div class="col-12 col-md-4 col-lg-3">
                        <div class="book-detail-price">
                             @if($book->xbook_hard_discount)
                                <span class="title-price-old">{{FarsiLib::convertDigit(number_format($book->xbook_hard_price))}}</span>
                                <span>{{FarsiLib::convertDigit(number_format($book->xbook_hard_price - $book->xbook_hard_discount))}} تومان </span>
                            @else
                                @if($book->xbook_hard_price)
                                <span>{{FarsiLib::convertDigit(number_format($book->xbook_hard_price))}} تومان </span>
                                @else
                                <span>رایگان</span>
                                @endif
                            @endif
                        </div>
                        <button class="aidBtn aidBtn-xs button-add-cart add-to-cart" type="submit" data-id="{{$book->xbookid}}" @if((int)$book->xbook_quantity < 1) disabled @endif>
                            <span>@if((int)$book->xbook_quantity < 1) ناموجود @else اضافه به سبد خرید  @endif</span>
                            <i class="icon-wallet"></i>
                        </button>

                        <button class="aidBtn aidBtn-xs button-add-cart add-continue-to-cart mt-2" type="submit" data-id="{{$book->xbookid}}" @if((int)$book->xbook_quantity < 1) disabled @endif>
                            <span>@if((int)$book->xbook_quantity < 1) ناموجود @else خرید کتاب@endif</span>
                            <i class="icon-wallet"></i>
                        </button>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="book-detail-desc col-12">
                        {!! $book->xbook_abstract !!}
                        <!-- <br>
                        <a class="pull-left">(بیشتر بخوانید)</a> -->
                    </div>

                </div>

            </div>
        </div>
    </div>
</section>
<section>
    <div class="container">
        @if($attachmentList)
        <h2 class="mt-4">فایل ها</h2>
        <div class="_line"></div>
        <div class="attachment-section d-flex pt-2">
            @foreach($attachmentList as $file)
                <a href="{{$file['file']}}" class="text-center mr-3">
                    <img src="/images/fileIcon/{{$file['type']}}.png" width="60px">
                    <span class="d-block">{{$file['name']}}</span>
                </a>
            @endforeach
        </div>
        @endif
    </div>
</section>
<section>
    <div class="container">
        @include('book::index.widget.bookRow',['title'=>'کتاب هایی از همین دسته', 'list'=>$categoryBooks])
    </div>
</section>
@include('book::index.detail.infoTable')
@include('book::index.widget.commentList')
@include('book::index.widget.tagList',['tags'=>$book->tags])
</div>
@endsection