@section('content')
<div class="scroll-progress-bar"></div>
<div class="blog-body">
	<div class="blog-banner-holder">
		<img src="/eqlid/blogbg.png">
		<div class="container">
			<div class="row align-items-center hero-wrap justify-content-between mt-5 mb-5">
				<div class="col-12 col-md-6 ">
					<div class="wrapper">
						<div class=" m-auto">
							<h1>{{ FarsiLib::faNormalize($article['xarticle_title'],true) }} </h1>
							<p class="text-justify">
								{{ FarsiLib::faNormalize($article['xarticle_abstract'],true) }} 
							</p>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
<div class="wrapper">
    <div class="body-section">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-1">
                    <div class="sidebar-item">
                        <div class="make-me-sticky">
                            <div class="blog-social-links d-flex flex-row flex-md-column">
                                <a class="kt-like-button js-article-add-rating" href="#" data-id="{{$article->xarticleid}}" data-type="1">
                                    <i class="icon-like"></i>
                                    <span class="kt-like-count">{{FarsiLib::convertDigit($article->like_count)}}</span>
                                </a>

                                <a class="kt-dislike-button js-article-add-rating" href="#" data-id="{{$article->xarticleid}}" data-type="2">
                                    <i class="icon-dislike"></i>
                                    <span class="kt-dislike-count">{{FarsiLib::convertDigit($article->dislike_count)}}</span>
                                </a>

                                <a href="#blog-comments" class="blog-single-meta-comments">
                                    <i class="icon-chat2"></i>
                                    <span>{{FarsiLib::convertDigit($article->comments_count)}}</span>
                                </a>

                                @if($agent->isMobile())
                                <a  class="social-share-button share-button" href="#">
                                    <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#dcdcdc"><path d="M0 0h24v24H0z" fill="none"/><path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/></svg>
                                </a>
                                <script>
                                    document.addEventListener("DOMContentLoaded", function(event) { 
                                    const shareButton = document.querySelector('.share-button');
                                    
                                    shareButton.addEventListener('click', event => {
                                        event.preventDefault();
                                    if (navigator.share) { 
                                    navigator.share({
                                        title: "{{$article['xarticle_title']}}",
                                        url: "/{{ App::getLocale() }}/blog/{{str_replace(' ','-',$article['url'])}}"
                                        }).then(() => {
                                        console.log('Thanks for sharing!');
                                        })
                                        .catch(console.error);
                                        } 
                                    });
                                })
                                </script>
                                @else
                                <a target="_blank" class="social-share-button social-whatsapp" data-type="whatsapp" data-id="39646" data-wpel-link="external" rel="nofollow external noopener" href="https://api.whatsapp.com/send?text={{url()->current()}}&amp;t='{{$article['xarticle_title']}}'" onclick="window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=700,height=450');return false">
                                    <i class="icon-whatsapp"></i>
                                </a>
                                <a target="_blank" class="social-share-button social-telegram" data-type="telegram" data-id="39646" data-wpel-link="external" rel="nofollow external noopener" href="https://telegram.me/share/url?url={{url()->current()}}&amp;text={{$article['xarticle_title']}}" onclick="window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=700,height=450');return false">
                                    <i class="icon-telegram"></i>
                                </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="blog-detail-wrapper">
                        @include('index.eqlid.breadcrumb')
                        <div class="_line"></div>
                        <article>
                            <div class="blog-detail-title">
                                <h2> {{ FarsiLib::faNormalize($article['xarticle_title'],true) }} </h2>
                            </div>

                            <div class="blog-detail-author d-flex justify-content-between">
                                <div class="bda-author">
                                    <img @if(File::exists(config("upload.User").$article->user->xuserid)) src="/pic/user/{{ $article->user->xuserid }}w30h30c1/{{ $article->user->xuserid }}.jpg" @else src="/images/Default_Profile_Picture1.jpg" @endif width="35" height="35" alt="" class="avatar avatar-default d-inline-block">
                                    <span class="bda-author-name">
                                        <a href="#">{{$article->user->xname.' '.$article->user->xfamily}}</a>
                                    </span>
                                </div>

                                <div class="bda-date d-flex align-items-center">
                                    <i class="icon-calendar"></i>
                                    <span class="bda-date-published">
                                        @if( App::getLocale() =='fa')
                                        {{ farsiDate(@$article['updated_at'], 'd F Y') }}
                                        @else
                                        {{ date('F d, Y', strtotime(@$article['updated_at'])) }}
                                        @endif
                                    </span>
                                </div>
                                <div class="bda-time d-none d-md-flex align-items-center">
                                    <i class="icon-time"></i>
                                    <span class="bda-time-txt">
                                        @t('time for reading article')
                                        {{ FarsiLib::faNormalize($article['xarticle_duration'],true) }} 
                                        @t('minutes')
                                        </span>
                                </div>
                            </div>
                            @if($bannerExist)
                            <figure class="blog-detail-fiqure">
                                <img src="/pic/article.banner/{{$article['xarticleid']}}w940h400c1/{{str_random()}}.png?nocache=1" class="blog-detail-fiqure-img" alt="کتاب صوتی ناطور دشت">
                                <figcaption class="hidden-seo"></figcaption>
                            </figure>
                            @endif

                            <div class="blog-detail-content">
                                {!! $article['xarticle_desc'] !!}</div>
                        </article>

                    </div>
                </div>
                <div class="col-12 col-md-3">
                    <div class="d-flex flex-column">
                        <div class="sidebar-item">
                            <div class="make-me-sticky">
                                @foreach ($advertise as $adv)
                                {!!$adv->xdescription!!}
                                @endforeach
                                @if($article['adv_url'])
                                <a class="service-box-3 p-0 mt-3" href="{{ $article['adv_url'] }}">
                                    <img class="full-image" src="/pic/article.advertise/{{ $article['xarticleid'] }}w255h236c1/{{ $article['xarticleid'] }}.jpg" />
                                </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@include('widget::comment.commentList',[
'type'=>'article',
'pageWidgetId'=>$article->xarticleid,
'externalData' =>['comments' => $comments]
])
@endsection