@var('isVideo',$list->group->xarticlegroup_title)
<a class="card card-blog animated BounceInLeft mb-5"  href="/{{ App::getLocale() }}/blog/{{str_replace(' ','-',$list['url'])}}">
    <div class="card-image">
        <span class="image__mask"></span>
        @if(isImageExist($list['xarticleid'],'banner'))
            <img class="img" src="/pic/article.banner/{{ $list['xarticleid'] }}w855h300c1/{{ $list['xarticleid'] }}.jpg" width="100%" height="250" alt="{{ $list['xarticle_title'] }}" title="{{ $list['xarticle_title'] }}">
        @else 
            <img class="img" src="/pic/article.image/{{ $list['xarticleid'] }}w855h300c1/{{ $list['xarticleid'] }}.jpg" width="100%" height="250" alt="{{ $list['xarticle_title'] }}" title="{{ $list['xarticle_title'] }}">
        @endif
        @if(Str::contains($isVideo,'ویدئو')) <i class="icon-video-play article-video-ply"></i> @endif
    </div>

    <div class="card-body">

        <h4 class="card-title">
            {{ FarsiLib::faNormalize(truncate($list['xarticle_title'],120),true) }}
        </h4>
        @if( App::getLocale() =='fa')
            <p class="card-title-desc">{!!  truncate(strip_tags($list['xarticle_abstract']),600) !!}</p>
        @else
            <p class="card-title-desc">{!!  truncate(strip_tags($list['xarticle_abstract']),500) !!}</p>
        @endif

    </div>

    <div class="card-footer">
        <span class="item__details d-flex flex-row align-items-center">
            <img src="/pic/user/{{ $list['xuserid'] }}w30h30c1/{{ $list['xuserid'] }}.jpg" width="30" height="30" alt="یوسف اسفندیاری" class="avatar avatar-30 wp-user-avatar wp-user-avatar-30 alignnone photo">
            <span class="item__details--author"> {{' '. $list->user->xname.' '.$list->user->xfamily }} </span>

            <time class="item__details--date">
                @if(config('app.lang') == 'fa')
                    @if(Str::contains($isVideo,'ویدئو'))
                    زمان مشاهده
                    @else
                    زمان مطالعه
                    @endif
                     : {{FarsiLib::convertDigit($list->xarticle_duration)}} دقیقه
                @else
                @if(Str::contains($isVideo,'ویدئو'))
                    view time
                    @else
                    reading time
                    @endif
                     : {{$list->xarticle_duration}} 
                      minutes 
                @endif 
            </time>

        </span>
    </div>

</a>

