import $ from 'jquery'
import { initialBlogSlick } from './blog-slick'
import {DigitHelper} from '../../../../js/helper/digitHelper'

var hT=0, hH=0;
$(document).ready(function () {
    initialBlogSlick();
    if($('.sidebar-item').length){
        hT = $('.sidebar-item').offset().top,
        hH = $('.sidebar-item').outerHeight();

        $(window).on('scroll', function () {
            scrollProgressBar();
            stickySidebar($(this));
        });
    }

    $(document).on('click','.comment-reply-link',function(event){
        event.preventDefault();        
        var parentid = $(event.currentTarget).data('commentid');
        var postid = $(event.currentTarget).data('postid');
        var type = $(event.currentTarget).data('type');
        var commentItem = $(event.currentTarget).closest('.comment-item.box-frame');
        var captcha = '';

        var replyExist = commentItem.find('.js-reply-comment');
        if(replyExist.length){
            replyExist.remove();
            $('.js-new-comment').removeClass('d-none');
            return;
        }

        $('.js-reply-comment').each(function(){
            $(this).remove();
        });
        
        var captchaAjaxResult = $.ajax({url: '/ajax_regen_captcha'});
        captchaAjaxResult.done(function(event){
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            captcha = event;
            var commentAdd = `
                <div class="row mt-3 js-reply-comment">
                <div class="col-12">
                    <div class="comment-item box-frame2">
                        <form class="js-comment-form" method="post" action="/Comment/addComment">				
                            <input type="hidden" name="id" value="`+ postid +`">
                            <input type="hidden" name="type" value="`+ type +`">
                            <input type="hidden" name="parent" value="`+ parentid +`">
                            <textarea class="c-ui-textarea" name="commentDesc" placeholder="لطفاً دیدگاهتان را اینجا درج نمایید. دیدگاه شما پس از بررسی، نمایش داده می شود."></textarea>
                            <div class="comment-action">
                                <img src="`+ captcha +`">
                                <input name="captcha" maxlength="8" type="text" value="" placeholder="کد امنیتی" required="">
                                <button class="btn btn-danger js-comment-add-new" type="submit">
                                    <span>ثبت و ارسال نظر</span>
                                </button>
                                <button class="btn btn-dark js-comment-cancel-reply">
                                    <span>لغو پاسخ</span>
                                </button>
                            </div>
                            
                        </form>
                    </div>
                </div>
            </div>
                `;
            
            commentItem.append(commentAdd);
            $('.js-new-comment').addClass('d-none');
        })
    });

    $(document).on('click','.js-comment-cancel-reply',function(event){
        $(this).closest('.js-reply-comment').remove();
        $('.js-new-comment').removeClass('d-none');
    });

    $(document).on('click','.js-comment-add-new',function(event){
        event.preventDefault();
        var currentForm = $(this).closest('.js-comment-form');
        
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/comment/addComment',
            data: currentForm.serialize(),

            error: function(xhr, ajaxOptions, thrownError){
                
                if(xhr.status == 401){
                    $('#loginModal').modal('show');
                    return;
                }
                $('#commentModal .cart-alert-icon').removeClass('success');
                $('#commentModal .cart-alert-icon i').removeClass('icon-check');

                $('#commentModal .cart-alert-icon').addClass('failed');
                $('#commentModal .cart-alert-icon i').addClass('icon-close');
                if (typeof xhr.responseJSON.message == 'object'){
                    $('#commentModal .cart-alert-text').text(" ");
                    $.each(xhr.responseJSON.message,function(key,value){
                        $('#commentModal .cart-alert-text').append(value + " </br>");    
                    })
                }else
                    $('#commentModal .cart-alert-text').text(xhr.responseJSON.message);

                $('.comment-action img').attr('src', xhr.responseJSON.captcha);
                $('#commentModal').modal('show');
            },
            
            success: function (data) {
                
                $('#commentModal .cart-alert-icon').addClass('success');
                $('#commentModal .cart-alert-icon i').addClass('icon-check');
                
                $('#commentModal .cart-alert-icon').removeClass('failed');
                $('#commentModal .cart-alert-icon i').removeClass('icon-close');

                $('#commentModal .cart-alert-text').text(data.message);
                $('#commentModal').modal('show');
            }
        });
        
    });

    $(document).on('click','.js-article-add-rating',function(event){
        const id = $(event.currentTarget).data("id")
        const type = $(event.currentTarget).data("type")
        let thisElement = $(event.currentTarget)
        event.preventDefault();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/Blog/addRating',
            data: {articleid:id,type:type},

            error: function(xhr, ajaxOptions, thrownError){
                
                if(xhr.status == 401){
                    $('#loginModal').modal('show');
                    return;
                }
                else
                    alert(xhr.responseJSON.message);
            },
            
            success: function (data) {
                $('.js-article-add-rating').removeClass('active');
                thisElement.addClass('active');
                $('.kt-like-button').find('span').html(DigitHelper.writeNumber(data.like));
                $('.kt-dislike-button').find('span').html(DigitHelper.writeNumber(data.dislike));
            }
        });
        
    });

    $(document).on('click','.blog-single-meta-comments',function(event){
        $('html, body').animate({
            scrollTop: $(".blog-comment-section").offset().top - 100
        }, 1000, function() {});
    });
});

function scrollProgressBar() {
    if ($('.scroll-progress-bar').length) {
        var height = $('.blog-detail-content').outerHeight() + $('#BreadCrumb').outerHeight() - ($(window).outerHeight() * 1.38) + ($('body').hasClass('admin-bar') ? 32 : 0),
            width = (($(window).scrollTop() - $('#BreadCrumb').offset().top + ($(window).outerHeight() * 0.12)) / height) * 100;
        if (width > 100) width = 100;
        if (width < 0) width = 0;
        $('.scroll-progress-bar').css('width', width + '%');
    }
}

function stickySidebar(scroll) {
    
    var self = $('.sidebar-item'),
        wH = $(window).height(),
        wS = scroll.scrollTop();
        
    if (wS > (hT  + wH - hH - 170 )) {
        
        self.css('position','absolute');
        self.css('padding','0 15px');
    }else{
        self.attr('style','');
    }
    

}