@extends('account::index.profile.layout')
@section('main')
<h4 class="c-profile-subtitle">
	لیست مرجوعی ها
</h4>

@if (count($errors) > 0)
	<div class="alert alert-danger">
		<ul>
			@foreach ($errors->all() as $error)
				<li>{{ $error }}</li>
			@endforeach
		</ul>
	</div>
@endif
@if(Session::get('success'))
	<div class="alert alert-success">
		<button class="close" data-close="alert"></button>
		<span>{!! Session::get('success') !!}</span>
	</div>
@endif
<form action="/profile/storeOrderReturn" method="POST">
	@csrf
	<input type="hidden" name="returned[invoice]" value="{{$invoice->xinvoiceid}}">
<div class="c-table row padright">
	<div class="c-table-body col-12">
		<div class="row c-table-row">
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">کالا </span>
				
					<select name="returned[product]" class="c-ui-input__field">
						@foreach($invoice->products as $product)
							<option value="{{$product->id}}">{{$product->name}}</option>
						@endforeach
					</select>
				</p>
			</div>
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">علت مرجوعی</span>
					<select name="returned[reason]" class="c-ui-input__field">
						<option value="1">کالا ایراد فنی دارد</option>
						<option value="2">کالا دارای خط و خش ظاهری می باشد</option>
						<option value="3">کالا مطابق با سفارش ثبت شده نمی باشد</option>
						<option value="4">از خرید منصرف شدم</option>
						<option value="5">کالا را اشتباه سفارش دادم</option>
						<option value="6">قطعه با دستگاه مطابقت ندارد</option>
					</select>
					
				</p>
			</div>
			
		</div>

		<div class="row c-table-row">
			<div class="c-table-cell col-12">
				<p>
					<span class="c-table-cell-title">توضیحات</span>
					<textarea name="returned[desc]" rows="5" class="c-ui-input__field"></textarea>
				</p>
			</div>
			
		</div>
		
	</div>
	<div class=" justify-content-end d-flex align-self-start add-info-wrapper-button">
		<button class="aidBtn aidBtn-xs comment-add-new" type="submit">
		      <span>ذخیره اطلاعات</span>
			</button>
	</div>
</div>
</form>
<div class="returned-alert c-cart row">
	<p >
		لطفا در توضیحات ثبت مرجوع علت را کامل توضیح دهید همچنین شماره موبایلی را اعلام بفرمایید که واتساپ روی آن نصب باشد. <br>
همکاران ما طی 3 روز کاری در واتساپ هماهنگی های لازم را با شما انجام می‌دهند.<br>
در این بازه 3 روزه نیاز به تماس با مرکز اطلاعات نیست و تمام پیگیری ها از طریق واتساپ صورت خواهد گرفت.<br>
پس از آن که درخواست خود را ثبت نمودید عکس کالای که می‌خواهید مرجوع کنید و عکس مدل دستگاه (برچسب یا لیبلی که مدل و سریال دستگاه ثبت شده است) را تهیه بفرمایید.

	</p>
</div>
<div class="return-post c-cart row">
	<h4 class="return-post_title">
		اطلاعات پستی
	</h4>
	<div class="returned-post_content">
		<span class="bold">آدرس: </span>
		<p>آدرس جاده قدیم قم بعد از کهریزک داخل 60 متری شورآباد نبش خیابان ششم شمالی معدن11 انبار مشتریان گلدیران تحویل گیرنده آقای زائر</p>
		<span class="bold">کد پستی:</span>
		<p>1818164357</p>
	</div>
</div>
@endsection