<div class="cart-item">
    <div class="row  align-items-center">
        @if(config('app.shop') == 'product')
        <div class="col-md-2 picCol">
            <img src="{{ imageUrl('product',$item->id,115,150) }}" alt="{{ $item->name }}">
        </div>
        <div class="col-md-5 detailCol">
            {{ $item->name }}
        </div>
        @else
        <div class="col-md-2 picCol">
            <img src="{{ imageUrl('book',$item->xbookid,115,150) }}" alt="{{ $item->xbook_title }}">
        </div>
        <div class="col-md-5 detailCol">
            {{ $item->xbook_title }}
            
            <p>@t('author'): {{implode(' ، ',$item->author->pluck('xauthor_name')->all())}}</p>
            @if($item->translator->count() > 0)
                <p>@t('translator'): {{implode(' ، ',$item->translator->pluck('xauthor_name')->all())}}</p>
            @endif
            <p>@t('publisher'): {{$item->publisher->xpublisher_name}}</p>
            
        </div>
        @endif
        <div class="col-md-1 quantityCol">
            {{ FarsiLib::convertDigit($item->pivot->xinvoiceitem_quantity) }} عدد
        </div>
        <div class="col-md-3 priceCol">
            @if($item->discount)
                <div class="price price-discount">تخفیف  {{ FarsiLib::convertDigit($item->pivot->xinvoiceitem_discount) }} تومان</div>
                <div class="price price-total">{{ FarsiLib::convertDigit($item->pivot->xinvoiceitem_price) }}تومان</div>
            @else
                <div class="price price-total">{{ FarsiLib::convertDigit($item->pivot->xinvoiceitem_price) }}تومان</div>
            @endif
        </div>
    </div>
</div>