@extends('account::index.profile.layout')
@section('main')
<div class="d-flex">
	<h4 class="c-profile-subtitle">
		سفارش {{FarsiLib::convertDigit($invoice->xinvoice_number)}}
		<span>ثبت شده در تاریخ {{FarsiLib::g2jDate($invoice->xinvoice_date,true)}}</span>
	</h4>
	@if($invoice->xinvoice_status == 'onlinepaymentfinal')
	<a href="/profile/downloadInvoicePdf/{{$invoice->xinvoiceid}}" class="c-profile-downloadPdf">
		<img width="30" src="/images/fileIcon/pdf.png" class="d-block m-auto">
		دانلود فاکتور
	</a>
	@endif
</div>
<div class="c-table row padright">
	<div class="c-table-body col-12">
		<div class="row c-table-row">
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">تحویل گیرنده</span>
					{{$invoice->xinvoice_ads_name}}
				</p>
			</div>
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">شماره تماس تحویل گیرنده</span>
					{{FarsiLib::convertDigit($invoice->xinvoice_ads_phone)}}
				</p>
			</div>
		</div>

		<div class="row c-table-row">
			<div class="c-table-cell col-12">
				<p>
					<span class="c-table-cell-title">آدرس تحویل گیرنده</span>
					{{$invoice->xinvoice_ads_address}}
				</p>
			</div>
			<!-- <div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">زمان تحویل</span>
					@if(!$invoice->xinvoice_delivery_time)
						@t('unknown')
					@else
						{{--$invoice->xinvoice_delivery_time--}}
					@endif
				</p>
			</div> -->
		</div>

		<div class="row c-table-row">
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">مبلغ قابل پرداخت</span>
					@if($invoice->xinvoice_status == 'offlinepaymentsend')
						{{FarsiLib::convertDigit(number_format($invoice->xinvoice_total - $invoice->xinvoice_discount))}} تومان
					@else
						۰
					@endif
				</p>
			</div>
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">تخفیف</span>
					{{FarsiLib::convertDigit(number_format($invoice->xinvoice_discount))}} تومان
				</p>
			</div>
			
		</div>

		<div class="row c-table-row">
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">نحوه ارسال</span>
					{{t($invoice->xinvoice_ship)}}
					@if($invoice->xinvoice_ship == 'post')
						<span class="c-table-cell-title">(کد مرسوله: {{$invoice->xinvoice_ship_code}})
							<a href="http://newtracking.post.ir/" style="color: red;"> پیگیری مرسوله پستی </a>
						</span>
					@endif
				</p>
			</div>
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">هزینه ارسال</span>
					{{FarsiLib::convertDigit(number_format($invoice->xinvoice_ship_price))}} تومان
				</p>
			</div>
			
		</div>
		<div class="row c-table-row">
			<div class="c-table-cell col-12">
				<p>
					<span class="c-table-cell-title">مبلغ کل</span>
					{{FarsiLib::convertDigit(number_format($invoice->xinvoice_total))}} تومان
				</p>
			</div>
		</div>

	</div>
</div>

<div class="row">

    <div class="cart-list cart-list-box col-12">
        @foreach (config('app.shop') == 'product' ? $invoice->products : $invoice->books as $item)
            @include('account::index.profile.orderDetailItem',['item' => $item])
        @endforeach
    </div>

</div>

@endsection