@extends('account::index.profile.layout')
@section('main')
<h4>آدرس ها</h4>
<div class="c-address">
	<div class="row">
		@foreach($addresses as $address)
		<div class="col-12 col-md-6">
			<div class="c-cart c-profile-address-card" data-address='{{json_encode($address->only("xaddressid","xaddress_content","xaddress_title","xaddress_phone","xprovinceid","xcityid","xregionid","xparishid"))}}'>
				<div class="c-profile-card-content">
					{{$address->xaddress_content}}
				</div>
				<div class="c-profile-card-data">
					<ul class="list-group">
						<li class="list-group-item">
							<span class="pMenuSideLink pm-addinfo icons">عنوان  : {{$address->xaddress_title}}</span>
						</li>
						<li class="list-group-item">
							<span class="pMenuSideLink pm-mobile icons">شماره تلفن  : {{FarsiLib::convertDigit($address->xaddress_phone)}}</span>
						</li>
					</ul>
					<div class="c-profile-card-actions">
						<button class="btn-note js-edit-address-btn" data-id="{{$address->xaddressid}}" data-toggle="modal" data-target="#changeAddressModal">ویرایش</button>
						<button class="btn-note js-remove-address-btn" data-id="{{$address->xaddressid}}">حذف</button>
					</div>
				</div>
			</div>
		</div>
		@endforeach
		<div class="col-12 col-md-6">
			<button class="js-add-address-btn c-profile-add-address-card" data-toggle="modal" data-target="#changeAddressModal">آدرس جدید</button>
		</div>
	</div>
</div>

@endsection

@section('modals')
  @include('cart::index.addressModal',['submitId' => 'f-submitAddress-profile'])
@endsection