@extends('account::index.profile.layout')
@section('main')
<h4 class="c-profile-subtitle">
	اطلاعات شخصی
</h4>
@if (count($errors) > 0)
	<div class="alert alert-danger">
		<ul>
			@foreach ($errors->all() as $error)
				<li>{{ $error }}</li>
			@endforeach
		</ul>
	</div>
@endif
@if(Session::get('success'))
	<div class="alert alert-success">
		<button class="close" data-close="alert"></button>
		<span>{!! Session::get('success') !!}</span>
	</div>
@endif
<form action="/profile/storeAdditionalInfo" method="POST">
	@csrf
<div class="c-table row padright">
	<div class="c-table-body col-12">
		<div class="row c-table-row">
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">نام </span>
					<input class="c-ui-input__field" type="text" name="additionalinfo[first_name]" value="{{$user->userInfo->xname}}" placeholder="نام خود را وارد کنید" aria-invalid="false">
				</p>
			</div>
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">نام خانوادگی </span>
					<input class="c-ui-input__field" type="text" name="additionalinfo[last_name]" value="{{$user->userInfo->xfamily}}" placeholder="نام خانوادگی خود را وارد نمایید" aria-invalid="false">
				</p>
			</div>
			
		</div>

		<div class="row c-table-row">
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">پست الکترونیک</span>
					<input class="c-ui-input__field" type="text" name="additionalinfo[email]" value="{{$user->userInfo->xemail}}" placeholder="آدرس ایمیل خود را وارد نمایید" aria-invalid="false">
				</p>
			</div>
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">کد ملی   </span>
					<input class="c-ui-input__field" type="text" name="additionalinfo[intcode]" value="{{$user->userInfo->xintcode}}" placeholder="کد ملی خود را وارد کنید" aria-invalid="false" @if($user->userInfo->xintcode) disabled @endif>
				</p>
			</div>
			<!-- <div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title"> تاریخ تولد</span>
					<input class="c-ui-input__field" type="text" name="additionalinfo[brithday]" value="{{$user->userInfo->xbirthday}}" placeholder="تاریخ تولد" aria-invalid="false">
				</p>
			</div> -->
		</div>
		<div class="row c-table-row">
			<div class="c-table-cell col-6">
				<p>
					<span class="c-table-cell-title">شماره تماس  </span>
					<input class="c-ui-input__field" type="text" name="additionalinfo[mobile]" value="{{$user->userInfo->xmobile}}" placeholder="شماره موبایل خود را وارد کنید" aria-invalid="false">
				</p>
			</div>
		</div>
	</div>
	<div class=" justify-content-end d-flex align-self-start add-info-wrapper-button">
		<button class="aidBtn aidBtn-xs comment-add-new" type="submit">
		      <span>ذخیره اطلاعات</span>
			</button>
	</div>
</div>
</form>
@endsection