@extends('account::index.auth.layout')
@section('content')

<section>
  <div class="container">
    <div class="bp-section">

      <div class="" id="registerController">
        <div class="bp-title d-flex justify-content-center flex-column align-items-center">
          <a href="/"><img src="/eqlid/logo.png" alt="eqlid"></a>
          <h1>{{ @$config['site']['registerText'] }}</h1>
        </div>
        <div class="bp-box bp-box-limit m-auto row">
        <form class="login-form w-100 p-0 col-12" action="{{ url('/User/signup') }}" method="POST">
          @csrf
          @if (Request::has('previous'))
          <input type="hidden" name="previous" value="{{ Request::get('previous') }}">
          @else
          <input type="hidden" name="previous" value="{{ URL::previous() }}">
          @endif
          <div class="form-group mobile-section">
            <label for="emailAddress">شماره موبایل</label>
            <input type="text" name="mobile" id="mobileRegisterForm" autocomplete="off" class="form-control input-lg input-ltr c-ui-input__field" pattern="09[0-9]{9}" maxlength="11" title="شماره موبایل خود را در قالب 09123456789 وارد نمائید" value="{{ old('username') }}">
            
            <div class="error c-ui-feedback-hint" id="register-mobile-num-required"></div>
          </div>

          <div class="form-group password-section ">
            <label for="emailAddress">رمز عبور</label>
            <input type="password" name="password" id="passwordRegisterForm" autocomplete="off" class="form-control input-lg input-ltr c-ui-input__field" placeholder="رمز عبور خود را وارد نمائید.">
            <div class="error c-ui-feedback-hint" id="register-password-num-min"> </div>
          </div>


          <div class="custom-control custom-checkbox mt-4 pr-0">
            <input type="checkbox" class="custom-control-input" id="agreementID" @if (old('agreement')) checked="checked" @endif>
            <label class="custom-control-label font-size-09" for="agreementID">حریم خصوصی و  قوانین استفاده از سرویس های شرکت مشتریان گلدیران را مطالعه نموده و با کلیه موارد آن موافقم.
            </label>
          </div>

          <div class="btn  loginBtn mt-4 js-register-code-button">ثبت نام</div>
        </form>
        <div class="col-12 p-0 mt-2"> <hr></div>
        <div class="d-flex justify-content-between col-12 p-0">
          <div class="text-muted">
          قبلا ثبت نام کرده اید؟
          </div>
          <a href="/User/login" class="btn-link-spoiler bold">
              وارد شوید
            </a>
        </div>
        

        @if(Session::get('success'))
        <div class="alert alert-success">
          <button class="close" data-close="alert"></button>
          <span>{!! Session::get('success') !!}</span>
        </div>
        @endif

      </div>
      </div>

    </div>
  </div>
</section>
@endsection