import Toastify from 'toastify-js'
import $ from 'jquery'
import {DigitHelper} from '../../../../js/helper/digitHelper'

export class Favorite {
    constructor() {
        this.removeElm = $('.js-remove-favorite-btn');
        this.updateElm = $('.js-update-favorite-btn');
    }

    binding() {

        this.removeElm.on("click", (event) => {
            event.preventDefault();
            let id = $(event.currentTarget).data("id");
            this.removeAddressAjax($(event.currentTarget),id)
        });

        this.updateElm.on("click", (event) => {
            event.preventDefault();
            let id = $(event.currentTarget).data("id");
            this.updateFavoriteAjax($(event.currentTarget),id)
        });

    }

    updateFavoriteAjax(element,id){
        let result = this.sendAjax({id:id},'/Profile/updateFavorite');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            element.toggleClass('social-favorite-active');
            this.dispatchEvent('favorite.update');
        });

        result.fail((event) => {
            this.notify(JSON.parse(event.responseText).message,'danger');
        });
    }    

    removeAddressAjax(element,id){
        let result = this.sendAjax({id:id},'/Profile/removeFavorite');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            let parent = element.closest('.c-profile-comment-card').parent();
            parent.remove();
            this.dispatchEvent('favorite.remove');
        });

        result.fail((event) => {
            this.notify('خطا  در برقراری ارتباط','danger');
        });
    }

    dispatchEvent(event,data,element = null){
        switch(event){
            case 'favorite.remove':{
                this.notify('محصول مورد علاقه با موفقیت حذف شد.');
                break;
            }
            case 'favorite.update':{
                this.notify('محصول شما در لیست علاقه مندی ها به روز رسانی شد.');
                break;
            }
        }
    }


    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 3000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
          backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)",
        }).showToast();
    }

    sendAjax(data,url){
        const res = $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    dataType: "html",
                    data: data
                });
        return res;
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }
}
