import Toastify from 'toastify-js'
import $ from 'jquery'
import {DigitHelper} from '../../../../js/helper/digitHelper'

export class Comment {
    constructor() {
        this.changeLocationElm = $('.js-edit-comment-btn');
        this.createLocationElm = $('.js-add-comment-btn');
        this.removeElm = $('.js-remove-comment-btn');

        this.shipModalElm = $('#changeCommentModal');
        this.modalAddressElm = $('#f-valueComment');
        this.modalIdElm = $('#f-idComment');
        this.modalSubmitElm = $('#f-submitComment-profile');

    }

    binding() {

        this.shipModalElm.on('show.bs.modal', (event) => {
            const button = $(event.relatedTarget) 
            const modal = $(event.currentTarget)
            
            if (button.hasClass('js-edit-comment-btn')){
                const parent = button.closest('.c-profile-comment-card')
                const data = parent.data('comment')
                modal.find(this.modalAddressElm).val(data.xcomment_content)
                modal.find(this.modalIdElm).val(data.xcommentid)
            }
            else if (button[0] === this.createLocationElm[0]){
                modal.find(this.modalTitleElm).val('')
                modal.find(this.modalMobileElm).val('')
                modal.find(this.modalAddressElm).val('')
                modal.find(this.modalIdElm).val(0)
            }
          
        });

        this.modalSubmitElm.on("click" , (event) => {
            event.preventDefault();
            this.sendUpdateAddressAjax();
            this.shipModalElm.modal('hide');
        });

        this.removeElm.on("click", (event) => {
            event.preventDefault();
            let id = $(event.currentTarget).data("id");
            this.removeAddressAjax($(event.currentTarget),id)
        });
    }

    sendUpdateAddressAjax(){
        const data = {
            id : this.modalIdElm.val(),
            comment : this.modalAddressElm.val(),
        }
        // const parent = $(event.relatedTarget).closest('.c-profile-address-card')
        let result = this.sendAjax({data:data},'/Profile/updateComment');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");

            this.dispatchEvent('comment.update',JSON.parse(event));
            location.reload();
        });

        result.fail((event) => {
            this.notify(JSON.parse(event.responseText).msg,'danger');
        });
    }

    removeAddressAjax(element,id){
        let result = this.sendAjax({id:id},'/Profile/removeComment');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            let parent = element.closest('.c-profile-comment-card').parent();
            parent.remove();
            this.dispatchEvent('comment.remove');
        });

        result.fail((event) => {
            this.notify('خطا  در برقراری ارتباط','danger');
        });
    }

    dispatchEvent(event,data,element = null){
        switch(event){
            case 'comment.remove':{
                this.notify('دیدگاه  انتخابی از لیست حذف شد');
                break;
            }

            case 'comment.update':{
                this.notify('دیدگاه  با موفقیت تغییر پیدا کرد');
                break;
            }

            
        }
    }


    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 3000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
          backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)",
        }).showToast();
    }

    sendAjax(data,url){
        const res = $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    dataType: "html",
                    data: data
                });
        return res;
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }
}
