import Toastify from 'toastify-js'
import $ from 'jquery'
import {DigitHelper} from '../../../../js/helper/digitHelper'

export class Address {
    constructor() {
        this.changeLocationElm = $('.js-edit-address-btn');
        this.createLocationElm = $('.js-add-address-btn');
        this.removeElm = $('.js-remove-address-btn');

        this.shipModalElm = $('#changeAddressModal');
        this.modalTitleElm = $('#f-titleAddress');
        this.modalMobileElm = $('#f-mobileAddress');
        this.modalAddressElm = $('#f-valueAddress');
        this.modalNameElm = $('#f-name');
        this.modalpostalCodeElm = $('#f-postalCode');
        this.modalIdElm = $('#f-idAddress');
        this.modalSubmitElm = $('#f-submitAddress-profile');

        this.modalProvinceElm = $('#provinceListCombo');
        this.modalCityElm = $('#cityListCombo');
        this.modalRegionElm = $('#regionListCombo');
        this.modalParishElm = $('#parishListCombo');

    }

    binding() {

        this.shipModalElm.on('show.bs.modal', (event) => {
            const button = $(event.relatedTarget) 
            const modal = $(event.currentTarget)
            
            if (button.hasClass('js-edit-address-btn')){
                const parent = button.closest('.c-profile-address-card')
                const data = parent.data('address')
                modal.find(this.modalTitleElm).val(data.xaddress_title)
                modal.find(this.modalMobileElm).val(data.xaddress_phone)
                modal.find(this.modalAddressElm).val(data.xaddress_content)
                modal.find(this.modalIdElm).val(data.xaddressid)
                modal.find(this.modalNameElm).val(data.xaddress_name)
                modal.find(this.modalpostalCodeElm).val(data.xaddress_postal_code)
                modal.find(this.modalProvinceElm).find('option[value="'+ data.xprovinceid +'"]').prop('selected',true).trigger('change')
                modal.find(this.modalCityElm).find('option[value="'+ data.xcityid +'"]').prop('selected',true).trigger('change')
                modal.find(this.modalRegionElm).find('option[value="'+ data.xregionid +'"]').prop('selected',true).trigger('change');
                modal.find(this.modalParishElm).find('option[value="'+ data.xparishid +'"]').prop('selected',true);
            }
            else if (button[0] === this.createLocationElm[0]){
                modal.find(this.modalTitleElm).val('')
                modal.find(this.modalMobileElm).val('')
                modal.find(this.modalAddressElm).val('')
                modal.find(this.modalIdElm).val(0)
            }
          
        });

        this.modalSubmitElm.on("click" , (event) => {
            event.preventDefault();
            if (this.sendUpdateAddressAjax() != false)
                this.shipModalElm.modal('hide');
        });

        this.removeElm.on("click", (event) => {
            event.preventDefault();
            let id = $(event.currentTarget).data("id");
            this.removeAddressAjax($(event.currentTarget),id)
        });
    }

    sendUpdateAddressAjax(){
        const data = {
            id : this.modalIdElm.val(),
            title : this.modalTitleElm.val(),
            mobile : this.modalMobileElm.val(),
            address : this.modalAddressElm.val(),
            name : this.modalNameElm.val(),
            postalCode : this.modalpostalCodeElm.val(),
            province : this.modalProvinceElm.val(),
            city : this.modalCityElm.val(),
            region: this.modalRegionElm.val(),
            parish : this.modalParishElm.val(),
        }
        if (data.title == '' || data.title.length == 0){
            this.notify('عنوان آدرس باید وارد شود','danger');
            return false;
        }
        if (data.mobile == '' || data.mobile.length == 0){
            this.notify('شماره همراه باید وارد شود','danger');
            return false;
        }
        if (data.address == '' || data.address.length == 0){
            this.notify('آدرس به درستی وارد نشده است','danger');
            return false;
        }
        if (data.name == '' || data.name.length == 0){
            this.notify('ثبت اطلاعات نام گیرنده الزامی می باشد.','danger');
            return false;
        }
        if (data.province == null || data.province == '' || data.province.length == 0){
            this.notify('استان به درستی وارد نشده است','danger');
            return false;
        }
        if (data.city == null || data.city == '' || data.city.length == 0){
            this.notify('شهر به درستی وارد نشده است','danger');
            return false;
        }
        
        if (data.region == null || data.region == '' || data.region.length == 0){
            this.notify('منطقه به درستی وارد نشده است','danger');
            return false;
        }
        if (data.parish == null || data.parish == '' || data.parish.length == 0){
            this.notify('محله به درستی وارد نشده است','danger');
            return false;
        }
        if (data.postalCode == '' || data.postalCode.length == 0){
            this.notify('کد پستی به درستی وارد نشده است','danger');
            return false;
        }

        // const parent = $(event.relatedTarget).closest('.c-profile-address-card')
        let result = this.sendAjax({data:data},'/Profile/updateAddress');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");

            this.dispatchEvent('address.update',JSON.parse(event));
            location.reload();
        });

        result.fail((event) => {
            this.notify(JSON.parse(event.responseText).msg,'danger');
        });
    }

    removeAddressAjax(element,id){
        let result = this.sendAjax({id:id},'/Profile/removeAddress');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");
            
            let parent = element.closest('.c-profile-address-card').parent();
            parent.remove();
            this.dispatchEvent('address.remove',JSON.parse(event));
        });

        result.fail((event) => {
            this.notify('خطا  در برقراری ارتباط','danger');
        });
    }

    dispatchEvent(event,data,element = null){
        switch(event){
            case 'address.remove':{
                this.notify('آدرس انتخابی از لیست حذف شد');
                break;
            }

            case 'address.update':{
                this.notify('آدرس با موفقیت تغییر پیدا کرد');
                break;
            }

            
        }
    }


    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 3000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
          backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)",
        }).showToast();
    }

    sendAjax(data,url){
        const res = $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    dataType: "html",
                    data: data
                });
        return res;
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }
}
