import Toastify from 'toastify-js'
import $ from 'jquery'
import {DigitHelper} from '../../../../js/helper/digitHelper'

export class Account {
    constructor() {
        this.forgotPassBtnElm = $('.js-forget-pass-button');
        this.forgotCodeBtnElm = '.js-forget-code-button';
        this.registerCodeBtnElm = '.js-register-code-button';
        this.changePassBtnElm = '.js-change-pass-button';
        this.inputMobileElm = $('#mobileRegisterForm');
        this.inputPasswordElm = $('#passwordRegisterForm');
        this.passController = $('#passController');
        this.registerController = $('#registerController');
        this.body = $('.athenticate-form');

        this.codetemplate = `
        <div class="bp-section">
        <div class="bp-title d-flex justify-content-center flex-column align-items-center">
            <a href="/"><img src="/eqlid/logo.png" alt="eqlid"></a>
            <h1>یادآوری رمز عبور</h1>
        </div>
        <div class="bp-box bp-box-limit m-auto">
        <form class="login-form  w-100 p-0">
            <p>حداکثر تا یک دقیقه دیگر کدی 4 رقمی برای تأیید هویت به شماره موبایلتان ارسال می&zwnj;شود. لطفا کد را در کادر پایین بنویسید و روی دکمه تأیید کلیک کنید.</p>

            <div class="athenticate-form">
             <input class="c-ui-input__field" type="text" placeholder="____" maxlength="4" id="code" pattern="[0-9]{4}">
            </div>

            <div class="text-center">
              <div class="timer-pass-code">
                <span>دریافت مجدد کد تایید</span> (
                <span id="forget-pass-count-down-timer">00:00</span> )
              </div>
              <a class="resend-code cursor-pointer btn-link-spoiler d-none" id="login-resend-code">
                <i class="icon-reload"></i>
                ارسال مجدد کد
              </a>
            </div>

            <button class="btn btn-danger loginBtn js-forget-code-button mt-4">تائید</button>
          </form>
          </div>
          </div>
        `
    }

    binding() {

        this.forgotPassBtnElm.on("click" , (event) => {
            event.preventDefault();
            this.sendReqAuthCodeAjax();
        });

        $(this.registerCodeBtnElm).on("click" , (event) => {
            event.preventDefault();
            this.sendRegisterCodeAjax();
        });

        $(document).on('click','.js-ajax-login',(event) => {
            event.preventDefault();
            this.sendLoginRequestAjax();
        });

    }

    codeAuthBinding(){
        $(this.forgotCodeBtnElm).on("click" , (event) => {
            event.preventDefault();
            this.sendAuthCodeAjax();
        });

       // this.body.on('keyup', 'input', this.goToNextInput);
       // this.body.on('keydown', 'input', this.onKeyDown);
       // this.body.on('click', 'input', this.onFocus);

        let oneMinutes = 59,
        display = document.querySelector('#forget-pass-count-down-timer');
        this.startTimer(oneMinutes, display);
    }

    registerCodeBinding(){
        $(this.forgotCodeBtnElm).on("click" , (event) => {
            event.preventDefault();
            this.sendRegisterVerifyCodeAjax();
        });

       // this.body.on('keyup', 'input', this.goToNextInput);
       // this.body.on('keydown', 'input', this.onKeyDown);
       // this.body.on('click', 'input', this.onFocus);

        let oneMinutes = 59,
        display = document.querySelector('#forget-pass-count-down-timer');
        this.startTimer(oneMinutes, display);
    }

    passChangeBinding(){
        $(this.changePassBtnElm).on("click" , (event) => {
            event.preventDefault();
            this.sendChangePassAjax();
        });
    }

    sendReqAuthCodeAjax(){
        const mobile = this.inputMobileElm.val();

        const filter = /^0[7-9][0-9]{9}$/;
        if (!filter.test(mobile)){
            this.notify('شماره موبایل وارد شده صحیح نمیباشد.','danger')
            return false;
        }
        
        let result = this.sendAjax({mobile:mobile},'/User/sendOtp');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");

            this.dispatchEvent('otp.send');
            this.updatePage();
        });

        result.fail((event) => {
            this.notify(JSON.parse(event.responseText).msg,'danger');
        });
    }

    sendRegisterCodeAjax(){
        const mobile = this.inputMobileElm.val();
        const password = this.inputPasswordElm.val();

        const filter = /^0[7-9][0-9]{9}$/;
        if (!filter.test(mobile)){
            this.notify('شماره موبایل وارد شده صحیح نمیباشد.','danger')
            return false;
        }
        
        let result = this.sendAjax({mobile:mobile, password:password},'/User/signupOtp');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");

            this.dispatchEvent('otp.send');
            this.registerUpdateCodePage();
        });

        result.fail((event) => {
            let message = '';
            $.each(JSON.parse(event.responseText).errors, (key, value) => {
                this.notify(value,'danger');
            });
            
            $.each(JSON.parse(event.responseText).errors, function(key, value){
                if (key == 'mobile'){
                    $('.form-group.mobile-section').addClass('has-error');
                    $('#register-mobile-num-required').html(value[0]);
                }else if (key == 'password'){
                    $('.form-group.password-section').addClass('has-error');
                    $('#register-password-num-min').html(value[0]);
                }
            });
        });
    }

    sendAuthCodeAjax(){
        // const code1 = $('#code1').val();
        // const code2 = $('#code2').val();
        // const code3 = $('#code3').val();
        // const code4 = $('#code4').val();

        // if (code1 == '' || code2 == '' || code3 == '' || code4 == ''){
        //     this.notify('کد وارد شده صحیح نمی باشد.','danger')
        //     return false;
        // }

        // let code = code1 + code2 + code3 + code4;
        // code = parseInt(code)
        const code = parseInt($('#code').val());
        if (!code || code == '' || code<1000 || code > 9999){
             this.notify('کد وارد شده صحیح نمی باشد.','danger')
             return false;
        }
        
        let result = this.sendAjax({code:code},'/User/verifyOtp');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");

            this.dispatchEvent('otp.recive');
            this.updatePasswordChangePage();
        });

        result.fail((event) => {
            this.notify(JSON.parse(event.responseText).msg,'danger');
        });
    }

    sendRegisterVerifyCodeAjax(){

        const code = parseInt($('#code').val());
        if (!code || code == '' || code<1000 || code > 9999){
             this.notify('کد وارد شده صحیح نمی باشد.','danger')
             return false;
        }
        
        let result = this.sendAjax({code:code},'/User/signupVerify');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");

            this.dispatchEvent('otp.recive');
            location.href="/user/welcome";
        });

        result.fail((event) => {
            this.notify(event.responseText,'danger');
        });
    }

    sendChangePassAjax(){
        const pass = $('#passwordRegisterForm').val();
        const repass = $('#repasswordRegisterForm').val();

        if (pass != repass){
            this.notify('رمز عبور های وارد شده با هم همخوانی ندارد','danger')
            return false;
        }
        if (pass == null || pass == '' || pass.length < 6){
            this.notify('رمز عبور باید حداقل دارای 6 کاراکتر باشد.','danger')
            return false;
        }

        let result = this.sendAjax({password:pass},'/User/changePassword');
        result.done((event) => {
            if (typeof event == "string" && event.indexOf("err_connection_refused") > -1) 
                return $(document).trigger("ajaxError");

            this.dispatchEvent('password.changed');
            location.href="/";
        });

        result.fail((event) => {
            this.notify(JSON.parse(event.responseText).msg,'danger');
            location.href="/User/forgot";
        });
    }

    sendLoginRequestAjax(){
        
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: $('.modal-login-form').attr('action'),
                data: $('.modal-login-form').serialize(),
    
                error: function(xhr, ajaxOptions, thrownError){
                    $('.js-login-error').removeClass('d-none');
                },
                
                success: function (data) {
                    location.reload();
                }
            });
         
    }

    updatePage(){
        this.passController.html(this.codetemplate);
        this.codeAuthBinding();
    }

    registerUpdateCodePage(){
        this.registerController.html(this.codetemplate);
        this.registerCodeBinding();
    }

    // <input id="code1" type="text" maxLength="1" size="1" min="0" max="9" pattern="[0-9]{1}" />
    //           <input id="code2" type="text" maxLength="1" size="1" min="0" max="9" pattern="[0-9]{1}" />
    //           <input id="code3" type="text" maxLength="1" size="1" min="0" max="9" pattern="[0-9]{1}" />
    //           <input id="code4" type="text" maxLength="1" size="1" min="0" max="9" pattern="[0-9]{1}" />

    updatePasswordChangePage(){
        const passTemplate = `
        <div class="bp-section">
            <div class="bp-title d-flex justify-content-center flex-column align-items-center">
                <a href="/"><img src="/eqlid/logo.png" alt="eqlid"></a>
                <h1>یادآوری رمز عبور</h1>
            </div>
            <div class="bp-box bp-box-limit m-auto">
          <form class="login-form  w-100 p-0">
            <div class="form-group mobile-section">
              <label for="emailAddress">رمز عبور</label>
              <input type="password" name="password" id="passwordRegisterForm" autocomplete="off"  class="form-control input-lg input-ltr c-ui-input__field dir-ltr" >
              <div class="invalid-feedback" id="register-mobile-num-required">رمز عبور صحیح نیست
              </div>
            </div>

            <div class="form-group mobile-section">
              <label for="emailAddress">تکرار رمز عبور</label>
              <input type="password" name="repassword" id="repasswordRegisterForm" autocomplete="off"  class="form-control input-lg input-ltr c-ui-input__field dir-ltr" >
              <div class="invalid-feedback" id="register-mobile-num-required">رمز عبور همخوانی ندارد
              </div>
            </div>

            <button type="submit" class="btn btn-primary  loginBtn js-change-pass-button">تغییر رمز عبور</button>
          </form>
          </div>
          </div>
        `
        this.passController.html(passTemplate);
        this.passChangeBinding();
    }

    goToNextInput(e) {
        let key = e.which,
          t = $(e.target),
          sib = t.next('input');

        if (key != 9 && key != 8 && key != 46 && !((key > 48 && key < 57)||(key > 96 && key < 105))) {
          e.preventDefault();
          return false;
        }

        if (key === 9) {
          return true;
        }

        if (key === 8 || key === 46){
            let prv = t.prev('input');
            if (!prv || !prv.length)
                prv = $(this.body).find('input').eq(0);
            prv.select().focus();
            return true;
        }

        if (!sib || !sib.length) {
          sib = $(this.body).find('input').eq(0);
        }
        sib.select().focus();
    }

    onKeyDown(e) {
        var key = e.which;

        if (key === 9 || key === 8 || key === 46 || (key >= 48 && key <= 57) || (key >= 96 && key <= 105)) {
          return true;
        }

        e.preventDefault();
        return false;
    }
      
    onFocus(e) {
        $(e.target).select();
    }

    startTimer(duration, display) {
        let timer = duration, minutes, seconds;
        let countTimer = setInterval(function () {
            minutes = parseInt(timer / 60, 10)
            seconds = parseInt(timer % 60, 10);

            minutes = minutes < 10 ? "0" + minutes : minutes;
            seconds = seconds < 10 ? "0" + seconds : seconds;

            display.textContent = DigitHelper.writeNumber(minutes) + ":" + DigitHelper.writeNumber(seconds);

            if (--timer < 0) {
                $('.timer-pass-code').addClass('d-none');
                $('.resend-code').removeClass('d-none');
                clearInterval(countTimer);
            }
        }, 1000);
    }

    dispatchEvent(event,data,element = null){
        switch(event){
            case 'otp.send':{
                this.notify('کد موقت برای شما ارسال گردید');
                break;
            }

            case 'otp.recive':{
                this.notify('کد وارد شده با موفقیت ثبت شد');
                break;
            }

            
        }
    }


    notify(msg,className=''){
        Toastify({
          text: msg,
          duration: 3000,
          newWindow: true,
          close: true,
          gravity: "top", 
          positionLeft: false, 
          className: className,
          backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)",
        }).showToast();
    }

    sendAjax(data,url){
        const res = $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: url,
                    type: "POST",
                    dataType: "html",
                    data: data
                });
        return res;
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }
}
