var openBtn = document.querySelectorAll('[data-toggle = "modal"]');
var closeBtn = document.querySelectorAll('[data-dismiss = "modal"]');


var eventClose = new Event('modal-close');

openBtn.forEach(item => {
  item.addEventListener('click',function(event) {
    var modal = document.getElementById(event.currentTarget.getAttribute('data-target'));
    modal.classList.add("show");
    modal.setAttribute('aria-hidden','false');
    var eventShow = new CustomEvent('modal-show', { bubbles: true, detail:{relatedTarget: event.currentTarget} })
    modal.dispatchEvent(eventShow);
  });
});

closeBtn.forEach(item => {
  item.addEventListener('click',function(event) {
    var modal = document.getElementById(event.currentTarget.getAttribute('data-target'));
    modal.setAttribute('aria-hidden','true');
    new Promise(resolve => setTimeout(resolve, 290)).then(()=> {modal.classList.remove("show");});
    modal.dispatchEvent(eventClose);
  });
});

window.onclick = function(event) {
  modal = document.querySelectorAll('.show[role="dialog"]')[0];
  if (event.target == modal) {
    modal.setAttribute('aria-hidden','true');
    modal.classList.remove("show");
  }
}

document.querySelector('.navbar-toggler').addEventListener('click', function(e){

  var htmlElm = document.querySelector('html');
  if(document.querySelector('html.nav-open')){
    htmlElm.classList.remove('nav-open');
  }else{
    htmlElm.classList.add('nav-open');
  }
});

HTMLElement.prototype.modal = function(action) {
  this.classList.add("show");
  this.setAttribute('aria-hidden','false');
  var eventShow = new CustomEvent('modal-show', { bubbles: true, detail:{relatedTarget: this} })
  this.dispatchEvent(eventShow);
};