
export class DigitHelper {
    static convertDigit(num, type) {
	    type = type ? type : 'en';
	    if (type == 'en') {
	        num = String(num);
	        num = (num).replace(/٫/g, '.');
	        num = (num).replace(/۰/g, '0');
	        num = (num).replace(/۱/g, '1');
	        num = (num).replace(/۲/g, '2');
	        num = (num).replace(/۳/g, '3');
	        num = (num).replace(/۴/g, '4');
	        num = (num).replace(/۵/g, '5');
	        num = (num).replace(/۶/g, '6');
	        num = (num).replace(/۷/g, '7');
	        num = (num).replace(/۸/g, '8');
	        num = (num).replace(/۹/g, '9');
	        num = (num).replace(/٤/g, '4');
	        num = (num).replace(/٥/g, '5');
	        num = (num).replace(/٦/g, '6');
	    } else if (type == 'fa') {
	        num = String(num);
	        num = (num).replace(/0/g, '۰');
	        num = (num).replace(/1/g, '۱');
	        num = (num).replace(/2/g, '۲');
	        num = (num).replace(/3/g, '۳');
	        num = (num).replace(/4/g, '۴');
	        num = (num).replace(/5/g, '۵');
	        num = (num).replace(/6/g, '۶');
	        num = (num).replace(/7/g, '۷');
	        num = (num).replace(/8/g, '۸');
	        num = (num).replace(/9/g, '۹');
	    }
	    return num;
	}

	static removeCommasNumber(num)
	{	
		if(typeof num != 'string')
			return false;
		num = num.replace(/[,]+/g, '');
		if(!num) num = '0';
		return num;
	}

	static addCommasNumber(nStr)
	{
		nStr += '';
		const x = nStr.split('.');
		let x1 = x[0];
		let x2 = x.length > 1 ? '.' + x[1] : '';
		let rgx = /(\d+)(\d{3})/;
		while (rgx.test(x1)) {
			x1 = x1.replace(rgx, '$1' + ',' + '$2');
		}
		return x1 + x2;
	}

	static readNumber(number)
	{
		return parseFloat(this.convertDigit(this.removeCommasNumber(number)));
	}	

	static writeNumber(number)
	{
		return this.convertDigit(this.addCommasNumber(number),'fa');
	}
 
}