<div class="shareBtnsFixed blog-social-links">
    @if ($agent->isMobile())
        <a class="social-share-button share-button" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="currentColor">
                <path d="M0 0h24v24H0z" fill="none" />
                <path
                    d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z" />
            </svg>
        </a>
        <script>
            document.addEventListener("DOMContentLoaded", function(event) {
                const shareButton = document.querySelector('.share-button');

                shareButton.addEventListener('click', event => {
                    event.preventDefault();
                    if (navigator.share) {
                        navigator.share({
                                title: "",
                                url: "{{ url()->current() }}"
                            }).then(() => {
                                console.log('Thanks for sharing!');
                            })
                            .catch(console.error);
                    }
                });
            })
        </script>
    @else
        <a target="_blank" class="social-share-button social-whatsapp" data-type="whatsapp" data-id="39646"
            data-wpel-link="external" rel="nofollow external noopener"
            href="https://api.whatsapp.com/send?text={{ url()->current() }}"
            onclick="window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=700,height=450');return false">
            <i class="icon-whatsapp"></i>
        </a>
        <a target="_blank" class="social-share-button social-telegram" data-type="telegram" data-id="39646"
            data-wpel-link="external" rel="nofollow external noopener"
            href="https://telegram.me/share/url?url={{ url()->current() }}"
            onclick="window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=700,height=450');return false">
            <i class="icon-telegram"></i>
        </a>
    @endif
</div>

<footer class="footer-area @if ((strtolower(config('app.controller')) == 'adv' || strtolower(config('app.controller')) == 'academy') && strtolower(config('app.action')) == 'index') footer-resize @endif">

    <div class="container footer-area-wrapper">

        <div class="d-flex align-items-center justify-content-between flex-column flex-md-row mb-3">
            <div>
                <h3>
                    {{ @$config['footer']['title'] }}
                </h3>
                <p> {{ @$config['footer']['subtitle'] }}</p>
            </div>

            <div class=" d-inline-flex align-items-center mt-3 justify-content-center text-center footer-btns">
                <div class="">
                    <a href="https://mail.eqlidsugar.com:2096/" class="btn my-sm-0 bg-red">@lang('eqlid.email address')</a>
                </div>

            </div>

        </div>

        <div class="row  justify-content-end footer list-wp">

            {!! @$config['seo']['footerLink'] !!}

            <div class="col-12 col-sm-6 col-md-4 mr-auto">
                <hr class="d-block d-md-none">
                <div>
                    <div class="d-flex align-items-center justify-content-between">
                        <img src="/public/eqlid/logo.png" class="mb-3" width="150">
                        <div class="social-offer mb-3">
                            @if (@$social)
                                @foreach ($social as $item)
                                    <a class="social-icon social-icon-sm social-icon-transparent social-{{ $item->xsocial_title }}"
                                        href="{{ $item->xsocial_link }}" title="{{ $item->xsocial_title }} address">
                                        <i class="icon-{{ $item->xsocial_title }}"></i>
                                        <i class="icon-{{ $item->xsocial_title }}"></i>
                                    </a>
                                @endforeach
                            @endif
                        </div>
                    </div>
                    {!! FarsiLib::convertDigit(@$config['footer']['text']) !!}
                </div>
            </div>
            @if (@$footerPages && false)
                @foreach ($footerPages as $item)
                    @if (($loop->iteration - 1) % 4 == 0)
                        <div class="col-6 col-sm-3 col-lg-2 d-none d-md-block">
                            <h4>دسترسی بیشتر</h4>
                            <ul class="nav flex-column">
                    @endif
                    <li class="nav-item">
                        <a class="nav-link"
                            href="/page/{{ $item->xpageid }}/{{ $item->xpage_title }}">{{ $item->xpage_title }}
                        </a>
                    </li>
                    @if ($loop->iteration % 4 == 0 || $loop->last)
                        </ul>
        </div>
        @endif
        @endforeach
        @endif
    </div>
    </div>
    @if (@$config['seo']['footerText'])
        <hr>
        <div class=" footer-area-wrapper container-fluid mt-2">
            <div class="row">
                <div class="col-12 ">
                    <article class="footer-seo">
                        <h4 class="title">{{ @$config['seo']['footerTitle'] }}</h4>
                        <p>{!! @$config['seo']['footerText'] !!}</p>
                    </article>
                </div>

            </div>
        </div>
    @endif
</footer>
