<!doctype html>
<html ⚡>
  <head>
    <meta charset="utf-8">
    <title>
        {{ @$title ? (preg_match('/^language\./', $title) ? trans($title):  $title):  '' }}
        {{ @$title2 ? ' | ' . str_limit($title2, $limit = 57, $end = ''):  ''}}
    </title>
    @if(@$canonical) <link rel="canonical" href="{{$canonical}}"/>
    @else <link rel="canonical" href="{{Str::finish(config('app.url'),'/') . Request::path()}}"/>  @endif
    @if(@$seoNoIndex)<meta name="robots" content="noindex, nofollow">@endif
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="enamad" content="983427"/>
    <meta name="amp-script-src" content="sha384-jk0CZnNTB6upjsJiRFH1odYXv7Hg31W2ndD-YC6i_fmHWcP5EKurTD_sJGnj2zU7
    sha384-M98gUod4H3woBlS_swNTF7dxvHrVstEAHwhma6-fVVWqJTVHIN0yuvPW3PjasNCV
    sha384-Acc3aL0cdDV_zeuATWnd82mF7L9OUQVNETo7DMSnAucMvvqbSTAJc2WDXZTsz-tv
    sha384-ARNyENl5Q9gXOdEoDsUfFzHVADJH5iIbZUZ_-oxPOjDHEmx5QivstrGPIoMzvvRS
    sha384-KdMBm8sZ86-tLgx5gVBefYMR-DtoopPeKs0pJ-WeQ4rI07Ku4m9ZsoACgFnOK5FC
    sha384-_xIlAL0x5uJsV2meObFrb9RiUCrcWA6A81noxTuD9u9O1-9Wt06zVbt--JcJ1PxC">
    <link rel="manifest" href="/manifest.json">
    <link href="/goldiran/favicon.ico" rel="shortcut icon" />
    <link rel="icon" type="image/png" href="favicon-32x32.png" sizes="32x32" />
    <link rel="icon" type="image/png" href="favicon-16x16.png" sizes="16x16" />

    <meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1">
    <style amp-boilerplate>body{-webkit-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-moz-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-ms-animation:-amp-start 8s steps(1,end) 0s 1 normal both;animation:-amp-start 8s steps(1,end) 0s 1 normal both}@-webkit-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-moz-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-ms-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-o-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}</style><noscript><style amp-boilerplate>body{-webkit-animation:none;-moz-animation:none;-ms-animation:none;animation:none}</style></noscript>
    
    <script async src="https://cdn.ampproject.org/v0.js"></script>
    <script custom-element="amp-sidebar" src="https://cdn.ampproject.org/v0/amp-sidebar-0.1.js" async=""></script>
    <script async custom-element="amp-accordion" src="https://cdn.ampproject.org/v0/amp-accordion-0.1.js"></script>

    @if(@$widgetConfig['mobile']['js'])
    @foreach(@$widgetConfig['mobile']['js'] as $js=>$value)
      <script async @if($js == 'amp-mustache') custom-template="{{$js}}" @else custom-element="{{$js}}" @endif  src="{{$value}}"></script>
    @endforeach
    @endif

    @yield('scripts')
    <style amp-custom>
      @php 
        readfile( resource_path('views/index/goldiran/sass/amp/base.css')); 
        readfile( resource_path('views/index/goldiran/sass/amp/grid.css')); 
        readfile( resource_path('views/index/goldiran/sass/amp/header.css')); 
        if(@$widgetConfig['mobile']){
          foreach($widgetConfig['mobile']['css'] as $css=>$value){
            readfile(base_path() . str_replace('resources/views/index/goldiran/modules/widgets/views','public/css/widgets',$css)); 
          }
        }
      @endphp
      
     </style>
    

    @if(@$schemaBreadCrump)
    <script type="application/ld+json">
        {!! $schemaBreadCrump !!}
    </script>
    @endif
    @if(@$schemaWebsite)
    <script type="application/ld+json">
        {!! $schemaWebsite !!}
    </script>
    @endif
    @if(@$schemaArticle)
    <script type="application/ld+json">
        {!! $schemaArticle !!}
    </script>
    @endif
    @if(@$schemaProduct)
    <script type="application/ld+json">
        {!! $schemaProduct !!}
    </script>
    @endif

  </head>
  <body>
    @if(!@$headerOff)
      @include('index.goldiran.amp-header')
    @endif
    
    @yield('content')
    
    @if(!@$footerOff)
      @include('index.goldiran.amp-footer')
    @endif
  </body>
</html>