<meta charset="utf-8"/>
<title>
    {{ @$title ? (preg_match('/^language\./', $title) ? trans($title):  $title):  '' }}
    {{ @$title2 ? ' | ' . str_limit($title2, $limit = 57, $end = ''):  ''}}
</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<meta content="{{$description ?? @$config['seo']['description']}}" name="description"/>

@if(@$canonical)
    <link rel="canonical" href="{{rtrim($canonical,'/')}}"/>
@else
    <link rel="canonical" href="{{rtrim(Str::finish(config('app.url'),'/') . Request::path(),'/')}}"/>    
@endif
@if(@$seoNoIndex)<meta name="robots" content="noindex, nofollow">@endif
<meta content="" name="author"/>
<meta name="csrf-token" content="{{ csrf_token() }}" />
<meta name="enamad" content="983427"/>

<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link href="/public/eqlid/logo.ico" rel="shortcut icon" />
<link rel="icon" type="image/png" href="/eqlid/logo.png" sizes="32x32" />
<link rel="icon" type="image/png" href="/eqlid/logo.png" sizes="16x16" />

    <meta property="og:type" content="website">
    <meta property="og:title" content="{{@$title}}">
    <meta property="og:url" content="{{url()->full()}}">
    <meta property="og:image" content="https://eqlidsugar.com/eqlid/logo.png">
    <meta property="og:image:secure_url" content="https://eqlidsugar.com/eqlid/logo.png" />
    <meta property="og:image:width" content="135">
    <meta property="og:image:height" content="200">

<!-- Favicons -->
<link rel="shortcut icon" href="">
<link rel="apple-touch-icon" href="" sizes="57x57">
<link rel="apple-touch-icon" href="" sizes="72x72">
<link rel="apple-touch-icon" href="" sizes="114x114">
<link rel="apple-touch-icon" href="" sizes="144x144">

@if(in_array(strtolower(config('app.controller')),['shop','product','cart','shipping','payment','gbox']))
    <link href="/css/assets/vendor.css" rel="stylesheet">
@else
   <link href="/css/app.css" rel="stylesheet"> 
@endif

@if(in_array(strtolower(config('app.controller')),['cart','shipping','payment']))
    <link href="/css/assets/cart.css" rel="stylesheet">
@endif

@var('dir', config('app.dir', 'ltr'))

<noscript>
    <link rel="stylesheet" href="{{ asset('/assets/plugins/jquery-file-upload/css/jquery.fileupload-noscript.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/plugins/jquery-file-upload/css/jquery.fileupload-ui-noscript.css') }}">
</noscript>


<script>
    var section = "{{ config('app.section') }}",
    	controller = "{{ config('app.controller') }}",
    	action = "{{ config('app.action') }}",
    	locale = "{{ config('app.localization') }}",
    	lang = "{{ App::getLocale() }}",
    	environment = '{{ App::environment() }}',
    	random = "{{ config('app.random') }}";

    window.dir =  "{{ config('app.dir') }}";
</script>


@if(@$schemaBreadCrump)
<script type="application/ld+json">
    {!! $schemaBreadCrump !!}
</script>
@endif
@if(@$schemaWebsite)
<script type="application/ld+json">
    {!! $schemaWebsite !!}
</script>
@endif
@if(@$schemaArticle)
<script type="application/ld+json">
    {!! $schemaArticle !!}
</script>
@endif
@if(@$schemaProduct)
<script type="application/ld+json">
    {!! $schemaProduct !!}
</script>
@endif