<div class="fileinput fileinput-new" data-provides="fileinput">
    <div class="fileinput-new thumbnail custom-thumbnail">
        @if (@$exist and @$href)
            <div class="fileinput-icon">
                <img src="{{ @$src ? $src: ($type == 'video' ? '/images/flatIcon/mp4.png' : '/images/flatIcon/pdf.png') }}" alt="" />
                <a href="{{ $href }}" >
                    @if (@$fileName)
                        <span style="display: inline-block;direction: ltr;">{{ @$fileName }}</span>
                    @endif 
                    @if (@$fileSize)
                        <span>({{ FarsiLib::convertDigit(@$fileSize) }} @lang('language.kb'))</span>
                    @endif
                    @if (!@$fileName and !@$fileSize) 
                        <span>@lang('language.download')</span>
                    @endif   
                </a>
            </div>
        @elseif (@$exist and @$src)
            <div class="fileinput-icon" style="position: relative; overflow: hidden;">
                <img src="{{ $src }}" alt="" />
                @if (@$srcLarge)
                    <div class="mix-details">
                        <a href="{{ $srcLarge }}" class="mix-preview fancybox-button" title="">
                            <i class="fa fa-search"></i>
                        </a>
                    </div>
                @endif    
            </div>
        @else
            <img src="{{ @$defaultSrc ? $defaultSrc:  (@$href ? '/images/icon/document128.png': '/assets/plugins/metronic/img/noimage.gif') }}" alt="" />
        @endif
    </div>
    <div class="fileinput-preview fileinput-exists thumbnail" style="width: 200px; max-height: 150px;"
        @if (@$href) data-icon="{{ @$src ? $src:  '/images/icon/document128.png' }}" @elseif (@$defaultSrc and @$src) data-icon="{{ @$defaultSrc ? $defaultSrc:  '/images/noimage.gif' }}" @endif>
    </div>
    @if (!@$previewMode)
        <div>
            <span class="btn btn-primary btn-file @if(config('app.dir') == 'ltr') pull-right @endif" >
                <span class="fileinput-new">@lang('language.browse') </span>
                <span class="fileinput-exists">@lang('language.browse') </span>
                {!! Form::file(@$name ? $name:  'frmFile') !!}
            </span>
            <a href="#" class="btn default fileinput-exists" data-dismiss="fileinput">
                @lang('language.refuse') 
            </a>

            @if (@$exist)
                @var('action', (@$action ? $action:  'deleteImg'))
                @if (@$href) 
                    @var('action', (@$action ? $action:  'deleteFile'))
                @endif
                
                <a href="{{ getCurrentURL('controller') . '/' . $action . '/' . @$id }}" onclick="App.removeFile(this, event, '{{ @$type }}');" class="btn btn-danger fileinput-remove @if (config('app.dir') == 'rtl') pull-right @else pull-left @endif ">
                    <i class="fa fa-trash-o"></i>    
                    @lang('language.remove') 
                </a>
            @endif
        </div>
    @endif    
</div> 
