@section('content')
    <table class="table table-striped table-bordered table-hover">
        <thead>
            <tr>
                @if (@$listBtn['showCheckbox'])
                    <th style="width: 0.05%" class="table-checkbox">
                        {!! Form::checkbox('checkall', 1, 0, array('class' => 'check-all')) !!}
                    </th>
                @endif
                @if (@$field)
                    <th class="text-center" scope="col" style="width: 0.5%;">#</th>
                    @foreach (@$field as $fldkey => $fld)
                        <th scope="col" style="{{ @$fld['css'] }}" @if(@$fld['sortable']) class="sorting"
                            onclick="App.sortList('{{ @$fld[sortable] }}')" class="sortable" id="sortable_{{ @$fld['sortable'] }}" @endif>
                            {{ @$fld['name'] }}
                        </th>
                    @endforeach
                    @if (!@$hidelistbtn)
                        <th style="width: 0.1%;">&nbsp;</th>
                    @endif
                @endif
            </tr>
        </thead>
        <tbody>
            @var('cnt', (@$list->currentPage() - 1) * @$list->perPage())
            @if (@$list)
                @foreach (@$list as $listkey => $item)
                    <tr class="odd gradeX {{ @$item['class'] }}">
                        @if (@$listBtn['showCheckbox'])
                            <td>
                                @var('itemid',$item['xid'])
                                {!! Form::checkbox("listchk[$itemid]", 1, 0, array('class' => 'checkboxes')) !!}
                            </td>
                        @endif
                        <td class="text-center"><b>{{ FarsiLib::convertDigit(++$cnt) }}</b></td>
                        @foreach(@$field as $i)
                            <td style="{{ @$i['css'] }}">@eval(@$i['php'])</td>
                        @endforeach
                        @if (!@$hidelistbtn)
                            <td>@include('backend.listBtn')</td>
                        @endif
                    </tr>
                @endforeach
            @endif
            @if (!@$list)
                <tr class="odd gradeX">
                    <td colspan="{{ count(@$field) }}">
                        <div style="padding: 30px; text-align: center;">@lang('language.no record found.')</div>
                    </td>
                </tr>
            @endif
        </tbody>
    </table>

    @if (@$list and !@$hidePagination)
        <div class="text-center">
            {!!  $list->render() !!}
        </div>
    @endif
    <script>
        $(window).off('load').load(function() {
            var id = "{{ config('app.id') }}";
            if (id && window.location.href.match(/popup=\d+/i) != null) {
                App.call($('.data-list'), {'url': "{{ getCurrentURL('controller') }}/edit/" + id, 'method': 'edit', 'id': id});
            }
        });
    </script>
@show