<?php
namespace App\Traits;

use Config;
use File;
use Input;
use Modules\Book\Models\Attachment;

trait UploadMultiFile {

    private function attachmentFiles($itemid) {
        $attachmentFiles = Attachment::where('xitemid', $itemid)
            ->where('xitem_type', config('app.controller'))
            ->get();
        $attachmentList = array();
        if ($attachmentFiles) {
            // copy attachment list
            foreach ($attachmentFiles as $ka => $file) {
                $controller = strtolower(config('app.controller'));
                $cid = md5("$controller.attachment." . $file['xitemid'] . "/" . $file['xid'] . env('APP_KEY'));
                $attachmentList[] = array(
                    "name" => $file['xname'],
                    "type" => $file['xextention'],
                    "size" => $file['xsize'],
                    "file" => "/download/$controller.attachment." . $file['xitemid'] . "/" . $file['xid'] . "/$cid/" . urlencode($file['xname']),
                    "data" => array(
                        "id" => $file['xid'],
                        "url" => "/download/$controller.attachment." . $file['xitemid'] . "/" . $file['xid'] . "/$cid/" . urlencode($file['xname']),
                    ),
                );
            }
            return $attachmentList;
        }

    }

    private function storeAttachmentFiles($id, $filesList) {
        if ($id && $filesList && is_array($filesList)) {
            $itemFolder = config('upload.' . config('app.controller'));
            $destnation = $itemFolder . "/attachment/$id/";

            foreach ($filesList as $storageName => $orginalName) {
                $srcfile = config('upload.Temporary') . $storageName;
                $fileData = array(
                    'xitemid' => $id,
                    'xitem_type' => config('app.controller'),
                    'xname' => $orginalName,
                    'xextention' => File::mimeType($srcfile),
                    'xsize' => (File::size($srcfile) > 1024 ? round(File::size($srcfile) / 1024) : floatval(File::size($srcfile))),
                );
                $attachmentId = Attachment::updateById($fileData)->xid;
                if (!is_dir($destnation)) {
                    File::makeDirectory($destnation, 0777, true);
                }
                if (File::exists($destnation . $attachmentId)) {
                    File::delete($destnation . $attachmentId);
                }

                File::move($srcfile, $destnation . $attachmentId);

            }
        }
    }

    //## book attachment upload
    public function uploadAttachment($id) {
        $id = intval($id);
        $attachment = Input::file('files');
        $attachmentId = 0;
        if ($id) {
            $itemFolder = config('upload.' . config('app.controller'));
            $destnation = $itemFolder . "/attachment/$id/";
            if (is_array($attachment)) {
                foreach ($attachment as $formName => $file) {
                    if ($file->isValid()) {
                        $fileData = array(
                            'xitemid' => $id,
                            'xitem_type' => config('app.controller'),
                            'xname' => $file->getClientOriginalName(),
                            'xextention' => $file->getClientOriginalExtension(),
                            'xsize' => ($file->getSize() > 1024 ? round($file->getSize() / 1024) : floatval($file->getSize())),
                        );
                        $attachmentId = Attachment::updateById($fileData)->xid;

                        if (!is_dir($destnation)) {
                            File::makeDirectory($destnation, 0777, true);
                        }
                        if (File::exists($destnation . $attachmentId)) {
                            File::delete($destnation . $attachmentId);
                        }

                        $file->move($destnation, $attachmentId);
                    }
                }
            }

            die(json_encode(['isCreated' => 'false', 'id' => $attachmentId]));
        }
        // if file uploaded in create book
        else if ($id == 0) {
            $destnation = config('upload.Temporary');
            if (is_array($attachment)) {
                foreach ($attachment as $formName => $file) {
                    if ($file->isValid()) {
                        if (!is_dir($destnation)) {
                            File::makeDirectory($destnation, 0777, true);
                        }

                        $fileName = time() . rand();
                        if (File::exists($destnation . $fileName)) {
                            File::delete($destnation . $fileName);
                        }

                        $file->move($destnation, $fileName);

                        $fileData = array(
                            'tempName' => $fileName,
                            'name' => $file->getClientOriginalName(),
                            'ext' => $file->getClientOriginalExtension(),
                            'size' => ($file->getSize() > 1024 ? round($file->getSize() / 1024) : floatval($file->getSize())),
                        );
                    }
                }
            }

            die(json_encode(['isCreated' => 'true', 'filesList' => json_encode($fileData)]));
        }

    }

    //## book attachment delete
    public function deleteAttachment() {
        $itemid = intval(Input::get('tid'));

        if ($itemid) {
            $attachid = intval(Input::get('id'));
            $itemFolder = config('upload.' . config('app.controller'));
            Attachment::remove($attachid);
            $bookFolder = $itemFolder . "/attachment/$itemid/";
            File::delete($bookFolder . $attachid);
        } else {
            $attachid = Input::get('id');
            $tempFolder = config('upload.Temporary');
            File::delete($tempFolder . $attachid);
        }
        die($attachid);
    }
}
