<?php namespace App\Services;

use App;
use Config;
use File;
use Request;
use App\Entities\Permission;
use Auth;
use DB;
use Modules\Page\Entities\CalculateData;
use Modules\Page\Models\PublicDataSource;

Class Lib {

    /**
     * //creates hash for image id  1000 => 000001/1000
     * @param int $id
     * @param bool $contact_id
     * @return string
     */
    public function uploadPath($id, $concat_id = true) {
        return str_pad(intval($id / 1000), 6, '0', STR_PAD_LEFT) . DIRECTORY_SEPARATOR . ($concat_id ? $id : '');
    }

    /**
     * call action
     * @param string $prefix
     * @param string $controller
     * @param string $controller
     * @param string $action
     * @param string $args
     * @return mixed
     */
    public function callAction($prefix = '', $controller = '', $action = 'index', $args = '') {
        Config::set('app.section', trim($prefix));
        $module = config('route.' . studly_case(trim($controller)));
        Config::set('app.module', trim($module));
        Config::set('app.controller', trim($controller));
        Config::set('app.action', trim($action));
        Config::set('app.random', str_random());
        
        $prefixPath = base_path() . ($module ? '/Modules/' . studly_case($module) : '/app') . '/Http/Controllers/' . studly_case($prefix);
        
        if (!File::exists($prefixPath)) {
            //return abort(404);
            if($controller == 'index') $controller = null;
            if($action == 'index') $action = null;
            $args = implode('/',array_filter([$controller,$action,$args]));
            
            $module = 'Page';
            $controller = 'Page';
            $action = 'render';
        }

        $controller = ($module ? ('Modules\\' . studly_case($module) . '\\') : 'App\\') . 'Http\\Controllers\\' . ($prefix ? (studly_case($prefix) . '\\') : '') . studly_case($controller) . "Controller";
        
        if($action && !method_exists($controller, $action)) {
            $args = $action;
        }
        $params = explode("/", $args);
        
        if ($params && preg_match('/\d+/', $params[0])) {
            Config::set('app.id', $params[0]);
        } else {
            Config::set('app.id', 0);
        }
        $app = app();

        if (!class_exists($controller)) {
            return abort(404);
        }
        if (preg_match('/^\d+$/', $action)) {
            $params = array($action);
            Config::set('app.id', $action);
        }

        $action = !method_exists($controller, $action) ? 'index' : $action;
        Config::set('app.action', trim($action));
        $controller = $app->make($controller);

        return $controller->callAction($action, $params);
    }

    /**
     * get current url
     * @param string $partname
     * @param bool $prefix
     * @return string
     */
    public function getCurrentURL($partname = '', $prefix = false) {
        $url = $prefix ? (env('APP_URL') . '/') : '';
        $localization = config('app.localization') ? ('/' . config('app.localization')) : '';
        $currentSection = (strtolower(config('app.section')) == 'index' ? '' : config('app.section'));

        switch ($partname) {
        case 'locale':
        case 'localization':
            $url .= (config('app.localization') ? config('app.localization') : '');
            break;
        case 'section':
            $url .= ((strtolower(config('app.section')) == 'index' and !$localization) ? '' : ($localization . '/')) . $currentSection;
            break;
        case 'controller':
            $url .= $localization . '/' . ($currentSection ? ($currentSection . '/') : '') . config('app.controller');
            break;
        case 'action':
            $url .= $localization . '/' . ($currentSection ? ($currentSection . '/') : '') . config('app.controller') . '/' . config('app.action');
            break;
        case 'id':
            $url .= $localization . '/' . ($currentSection ? ($currentSection . '/') : '') . config('app.controller') . '/' . config('app.action') . '/' . config('app.id');
            break;
        default:
            $url .= Request::path();
            break;
        }
        return $url;
    }

    /**
     * get path in array
     * @param string $path
     * @param array $current
     * @return array
     */
    public function getPath($path, $current = array()) {
        $localization = @$current['localization'] ? $current['localization'] : '';
        $section = @$current['section'] ? $current['section'] : '';
        $controller = @$current['controller'] ? $current['controller'] : '';
        $method = @$current['action'] ? $current['action'] : '';
        $param = @$current['param'] ? $current['param'] : '';

        $id = 0;
        $res = '/';
        if (is_array($path)) {
            $localization = @$path['localization'] ? $path['localization'] . '/' : (config('app.localization') ? config('app.localization') . '/' : '');
            $section = @$path['section'] ? $path['section'] : config('app.section');
            $res .= $localization . $section;
            if (@$path['controller'] and @$path['action'] and is_array(@$path['param']) or (@$path['controller'] and is_array(@$path['param']))) {
                $res .= '/' . $path['controller'] . (@$path['action'] ? '/' . $path['action'] : '');
                foreach ($path['param'] as $key => $param) {
                    if (preg_match('/\d+/', $param) and $key == 'id') {
                        $res .= '/' . $param;
                        $id = $param;
                    } else {
                        preg_match('/\?/', $res, $match);
                        if (!$match) {
                            $res .= "?$key=$param";
                            $param .= "?$key=$param";
                        } else {
                            $res .= "&$key=$param";
                            $param .= "&$key=$param";
                        }
                    }
                }
                $controller = $path['controller'];
                $method = @$path['action'];
            } elseif (@$path['controller'] and @$path['action']) {
                $res .= '/' . $path['controller'] . '/' . $path['action'];
                $controller = $path['controller'];
                $method = $path['action'];
            } else if (@$path['controller']) {
                $res .= '/' . $path['controller'];
                $controller = $path['controller'];
            }
        } else {
            $isURL = preg_match('/\//', $path) ? true : false;
            if ($isURL) {
                $segments = explode('/', $path);
                if ($segments) {
                    foreach ($segments as $segment) {
                        if (!trim($segment)) {
                            continue;
                        }

                        if (!$localization and in_array($segment, config('app.locales', ['en']))) {
                            $localization = $segment;
                        } elseif (!$section and in_array($segment, config('app.prefixes', []))) {
                            $section = $segment;
                        } elseif (!$controller and !preg_match('/\d+/', $segment)) {
                            $controller = $segment;
                        } elseif (!$method and !preg_match('/\d+/', $segment)) {
                            $method = $segment;
                        } else {
                            $id = intval($segment);
                        }
                    }
                }
                $localization = ($localization ? $localization : (config('app.localization') ? config('app.localization') . '/' : ''));
                $section = $section ? $section : config('app.section');
                $res .= $localization . $section . $path;
            }
        }
        return array(
            'path' => preg_replace('/\/+/', '/', $res),
            'localization' => str_replace('/', '', $localization),
            'section' => $section,
            'controller' => $controller,
            'action' => $method,
            'id' => $id,
            'param' => $param,
        );
    } 

    private function menuNavigation($list, $item) {
        $result = "";
        $currentCtrl = config('app.controller');
        $currentAction = config('app.action');
        $currentId = config('app.id');
        $isPermission = false;
        
        foreach ($list as $key => $value) {
            if ($value['parent_id'] == $item) {
                $active = $url = '';
                $childs = self::menuNavigation($list, $value['id']);
                if($value['url']){
                    $pathReturn = self::getPath($value['url'], ['section' => 'Admin']);
                    
                    if ($pathReturn['controller'] and $pathReturn['action'] and $pathReturn['id']) {
                        $active = ($pathReturn['controller'] == $currentCtrl and $pathReturn['action'] == $currentAction and $pathReturn['id'] == $currentId) ? 'active' : '';
                    } elseif ($pathReturn['controller'] and $pathReturn['action'] and !$pathReturn['id']) {
                        $active = ($pathReturn['controller'] == $currentCtrl and $pathReturn['action'] == $currentAction) ? 'active' : '';
                    } elseif ($pathReturn['controller'] and $pathReturn['id']) {
                        $active = ($pathReturn['controller'] == $currentCtrl and $pathReturn['id'] == $currentId) ? 'active' : '';
                    } elseif ($pathReturn['controller'] and $currentAction == 'index') {
                        $active = ($pathReturn['controller'] == $currentCtrl) ? 'active' : '';
                    }
                    $url = $pathReturn['path'];
                    if ($pathReturn['controller'] == 'logout') {
                        $url = "/auth/logout";
                    }else{
                        $isPermission = false;
                        $permission = new Permission(config('route.' . trim($pathReturn['controller'])), $pathReturn['controller'], @$pathReturn['action']);
                        if (Auth::check() && Auth::user()->hasPermission($permission)) {
                            $isPermission = true;
                        }
                        if(!$isPermission)   
                            continue;
                    }
                }
                else{
                    $url = 'javascript:;';
                    if(!$childs)
                        continue;
                }
                
                
                $result .= "<li class='{$active}'><a href='{$url}'>";
                
                if (@$value['icon']) {
                    if (preg_match('/^<[^>]+>/', $value['icon'])) {
                        $result .= $value['icon'];
                    } else {
                        $result .= "<i class='{$value['icon']}'></i>";
                    }

                } else {
                    $result .= "<i class='fa'></i>";
                }

                $translated = trim(trans('language' . '.' . $value['name']));
                if (preg_match('/^language\./', $value['name'])) {
                    $translated = trim(trans($value['name']));
                }
                $result .= '<span class="title">' . $translated . '</span><span class="selected"></span>';
                if (@$childs) {
                    $result .= '<span class="right ' . ($active ? 'open' : '') . '"><i class="fa fa-angle-down"></i></span>';
                }
                $result .= "</a>";

                if ($childs) {
                    $result .= "<ul class='sub-menu'> {$childs} </ul> </li>";
                } else {
                    $result .= '</li>';
                }
                
            }
        }
        return $result;
    }

    public function makeDBNavigation(){
        $list = \DB::table("admin_module")->orderBy('order','desc')->orderBy('parent_id','desc')->get();
        return self::menuNavigation($list,0);
    }

    public function makeNavigation($arrNav, $hasUL = false, $children = false) {
        if (is_array($arrNav)) {
            if ($children and $hasUL) {
                $return = '<ul class="sub-menu">';
            } else {
                $return = $hasUL ? '<ul>' : '';
            }
            $cnt = 0;
            foreach ($arrNav as $nav) {
                if ($nav['label']) {
                    $currentSection = config('app.section');
                    $currentCtrl = config('app.controller');
                    $currentAction = config('app.action');
                    $currentId = config('app.id');
                    $active = $url = '';
                    $permissionList = array();
                    if (@$nav['permission']) {
                        $permissionList = is_array($nav['permission']) ? $nav['permission'] : (is_string($nav['permission']) ? explode(',', $nav['permission']) : array());
                    }
                    if ($permissionList) {
                        foreach ($permissionList as $kp => $permission) {
                            $permissionList[$kp] = trim($permission);
                        }
                    }
                    $permissionExist = @$nav['permission'] ? 1 : 0;
                    if (!in_array($currentSection, $permissionList) and $permissionExist) {
                        continue;
                    }

                    if (@$nav['controller']) {
                        $active = $currentCtrl == @$nav['controller'] ? 'active' : '';
                        $pathReturn = self::getPath(array('controller' => $nav['controller'], 'action' => @$nav['action']), ['section' => $currentSection]);
                        $url = @$pathReturn['path'];
                    } elseif (@$nav['url']) {
                        //## active li
                        $pathReturn = self::getPath($nav['url'], ['section' => $currentSection]);
                        if ($pathReturn['controller'] and $pathReturn['action'] and $pathReturn['id']) {
                            $active = ($pathReturn['controller'] == $currentCtrl and $pathReturn['action'] == $currentAction and $pathReturn['id'] == $currentId) ? 'active' : '';
                        } elseif ($pathReturn['controller'] and $pathReturn['action'] and !$pathReturn['id']) {
                            $active = ($pathReturn['controller'] == $currentCtrl and $pathReturn['action'] == $currentAction) ? 'active' : '';
                        } elseif ($pathReturn['controller'] and $pathReturn['id']) {
                            $active = ($pathReturn['controller'] == $currentCtrl and $pathReturn['id'] == $currentId) ? 'active' : '';
                        } elseif ($pathReturn['controller'] and $currentAction == 'index') {
                            $active = ($pathReturn['controller'] == $currentCtrl) ? 'active' : '';
                        }
                        $url = $pathReturn['path'];
                        if ($pathReturn['controller'] == 'logout') {
                            $url = "/auth/logout";
                        }

                    } else {
                        $url = 'javascript:;';

                        //## active parent if child this page
                        $actvieParent = 0;
                        if (@$nav['children']) {
                            foreach ($nav['children'] as $child) {
                                if (@$child['controller']) {
                                    $actvieParent += $currentCtrl == @$child['controller'] ? 1 : 0;
                                    $pathReturn = self::getPath(array('controller' => $child['controller'], 'action' => @$child['action']), ['section' => $currentSection]);
                                    $url = @$pathReturn['path'];
                                } elseif (@$child['url']) {
                                    $pathReturn = self::getPath($child['url'], ['section' => $currentSection]);
                                    if ($pathReturn['controller'] and $pathReturn['action'] and $pathReturn['id']) {
                                        $actvieParent += ($pathReturn['controller'] == $currentCtrl and $pathReturn['action'] == $currentAction and $pathReturn['id'] == $currentId) ? 1 : 0;
                                    } elseif ($pathReturn['controller'] and $pathReturn['action'] and !$pathReturn['id']) {
                                        $actvieParent += ($pathReturn['controller'] == $currentCtrl and $pathReturn['action'] == $currentAction) ? 1 : 0;
                                    } elseif ($pathReturn['controller'] and $pathReturn['id']) {
                                        $actvieParent += ($pathReturn['controller'] == $currentCtrl and $pathReturn['id'] == $currentId) ? 1 : 0;
                                    } elseif ($pathReturn['controller'] and !$currentAction) {
                                        $actvieParent += ($pathReturn['controller'] == $currentCtrl) ? 1 : 0;
                                    }
                                }
                            }
                        }
                        $active = $actvieParent ? 'active' : '';
                    }

                    $start = ($cnt == 0 and !$hasUL) ? 'start' : '';
                    $classList = "$start $active";
                    $propStr = '';
                    if (@$nav['extra']) {
                        foreach ($nav['extra'] as $prop => $val) {
                            if (strtolower(trim($prop)) == 'class') {
                                $classList .= $val;
                            } else {
                                $propStr .= $prop . "='$val'";
                            }
                        }
                    }
                    $return .= "<li class='{$classList}' {$propStr} ><a href='{$url}'>";

                    if (@$nav['fa-icon']) {
                        if (preg_match('/^<[^>]+>/', $nav['fa-icon'])) {
                            $return .= $nav['fa-icon'] . ($children ? ' ' : '');
                        } else {
                            $return .= "<i class='{$nav['fa-icon']}'></i>" . ($children ? ' ' : '');
                        }

                    } else {
                        $return .= "<i class='fa'></i>" . ($children ? ' ' : '');
                    }

                    $translated = trim(trans(config('custom.site.lang', 'language') . '.' . $nav['label']));
                    if (preg_match('/^language\./', $nav['label'])) {
                        $translated = trim(trans($nav['label']));
                    }
                    $return .= '<span class="title">' . $translated . '</span><span class="selected"></span>';
                    if (@$nav['children']) {
                        $return .= '<span class="right ' . ($active ? 'open' : '') . '"><i class="fa fa-angle-down"></i></span>';
                    }
                    $return .= "</a>";
                    if (@$nav['children']) {
                        $return .= self::makeNavigation($nav['children'], true, $children = true);
                    }
                    $return .= '</li>';
                    $cnt++;
                }
            }
            $return .= $hasUL ? '</ul>' : '';
        }
        return $return;
    }

    //### translate with explode
    public function transExplode($msg, $seperator = ',', $perfix = 'language', $returnSeperator = '، ') {
        $msgList = explode($seperator, $msg);
        $res = '';
        if ($msgList) {
            $count = count($msgList);
            $cnt = 0;
            foreach ($msgList as $txt) {
                $cnt++;
                $res .= trans($perfix . '.' . trim($txt)) . ($cnt < $count ? "$returnSeperator" : '');
            }
        }
        return $res;
    }

    //## convert object to array
    public function object2array(&$obj, $recursive = false) {
        if (is_array($obj) or is_object($obj)) {
            foreach ($obj as $key => $val) {
                if ($recursive and (is_array($val) or is_object($val))) {
                    $res[$key] = self::object2array($val, true);
                } else {
                    $res[$key] = $val;
                }
            }
        } else {
            $res = $obj;
        }
        return $res;
    }

    /**
     * Get SVG content
     * @param string $filepath
     * @param string $class
     *
     * @return string|string[]|null
     */
    public function getSVG($name, $class = '', $echo = true)
    {
        $filepath = public_path().config('icon.'.$name);
        if (!is_string($filepath) || !file_exists($filepath)) {
            return '';
        }
        
        $svg_content = file_get_contents($filepath);

        $dom = new \DOMDocument();
        $dom->loadXML($svg_content);

        // remove unwanted comments
        $xpath = new \DOMXPath($dom);
        foreach ($xpath->query('//comment()') as $comment) {
            $comment->parentNode->removeChild($comment);
        }

        // remove unwanted tags
        $title = $dom->getElementsByTagName('title');
        if ($title['length']) {
            $dom->documentElement->removeChild($title[0]);
        }
        $desc = $dom->getElementsByTagName('desc');
        if ($desc['length']) {
            $dom->documentElement->removeChild($desc[0]);
        }
        $defs = $dom->getElementsByTagName('defs');
        if ($defs['length']) {
            $dom->documentElement->removeChild($defs[0]);
        }

        // remove unwanted id attribute in g tag
        $g = $dom->getElementsByTagName('g');
        foreach ($g as $el) {
            $el->removeAttribute('id');
        }
        $mask = $dom->getElementsByTagName('mask');
        foreach ($mask as $el) {
            $el->removeAttribute('id');
        }
        $rect = $dom->getElementsByTagName('rect');
        foreach ($rect as $el) {
            $el->removeAttribute('id');
        }
        $path = $dom->getElementsByTagName('path');
        foreach ($path as $el) {
            $el->removeAttribute('id');
        }
        $circle = $dom->getElementsByTagName('circle');
        foreach ($circle as $el) {
            $el->removeAttribute('id');
        }
        $use = $dom->getElementsByTagName('use');
        foreach ($use as $el) {
            $el->removeAttribute('id');
        }
        $polygon = $dom->getElementsByTagName('polygon');
        foreach ($polygon as $el) {
            $el->removeAttribute('id');
        }
        $ellipse = $dom->getElementsByTagName('ellipse');
        foreach ($ellipse as $el) {
            $el->removeAttribute('id');
        }

        $string = $dom->saveXML($dom->documentElement);

        // remove empty lines
        $string = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $string);

        $cls = array('svg-icon');
        if (!empty($class)) {
            $cls = array_merge($cls, explode(' ', $class));
        }
        if ($echo)
            echo '<span class="' . implode(' ', $cls) . '"><!--begin::Svg Icon | path:' . $filepath . '-->' . $string . '<!--end::Svg Icon--></span>';
        else
            return '<span class="' . implode(' ', $cls) . '"><!--begin::Svg Icon | path:' . $filepath . '-->' . $string . '<!--end::Svg Icon--></span>';
    }

    public function getDataFromSourceDatabase($widget){
        $dataSourceQuery = PublicDataSource::find($widget->source_model->id);
        eval("\$retriveData = {$dataSourceQuery->query}");
        $retriveData->orders = null;
        foreach ($widget->source_model->where as $key => $value) {
            if($value->operator == 'in')
                $retriveData->whereIn($value->column, array_values(explode(',',$value->value)));
            else
                $retriveData->where($value->column,$value->operator,$value->value);
        }
        foreach ($widget->source_model->order as $key => $value) {
            $retriveData->orderBy($value->column, $value->direction);
        }
        
        if($widget->source_model->count)
        $retriveData->take($widget->source_model->count);
        
        $data = $retriveData->get();

        return $data;
        foreach ($data as $key => $value) {
            foreach ($widget->parameters as $paramKey => $paramValue) {
                $newData[$paramKey] = $value[$key2];
            }
        }
    }

    public function getExternalData($dataScaffold,$itemId){
        switch ($dataScaffold->type) {
            case 'webService':
                $sources = explode('.',$dataScaffold->source);
                return $this->getWebServiceData($source[0],$source[1],$dataScaffold->data);
                break;
            case 'apiData':
                if($dataScaffold->source && method_exists(new CalculateData(), $dataScaffold->source)) {
                    return call_user_func_array("Modules\Page\Entities\CalculateData::{$dataScaffold->source}",[$dataScaffold->data,$itemId]);
                }
                
                return null;
                break;
            case 'dataSource':
                $dataSourceQuery = PublicDataSource::find($dataScaffold->source);
                eval("\$retriveData = {$dataSourceQuery->query}");
                return $retriveData->get();
                break;
            default:
                return null;
                break;
        }
    }
}